<?php

if (!defined('ABSPATH')) {
    exit(__('No Access!', 'fci'));
}

class FCI_Send_Whatsapp
{
    private $order_id;

    public function __construct($order_id)
    {
        $this->order_id = $order_id;
    }

    public function send($to)
    {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.wamessenger.net/sendMessage/' . get_fci_settings('wa-api'),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('phonenumber' => $to, 'text' => $this->body()),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;
    }


    public function body($type = '')
    {
        if ($type != '') {
            // payment
            $text = get_fci_settings('wa-text-payment');
        } else {
            // default
            $text = get_fci_settings('wa-text');

            $order = wc_get_order($this->order_id);
            $order_status = $order->get_status();
            $custom_message = get_fci_settings('custom-wa-message');


            if ($custom_message) {

                if ($order_status == 'pending' && strlen(get_fci_settings('wa-text-pending')) > 1) {
                    $text = get_fci_settings('wa-text-pending');
                }
                if ($order_status == 'processing' && strlen(get_fci_settings('wa-text-processing')) > 1) {
                    $text = get_fci_settings('wa-text-processing');
                }
                if ($order_status == 'completed' && strlen(get_fci_settings('wa-text-completed')) > 1) {
                    $text = get_fci_settings('wa-text-completed');
                }
                if ($order_status == 'refunded' && strlen(get_fci_settings('wa-text-refunded')) > 1) {
                    $text = get_fci_settings('wa-text-refunded');
                }
                if ($order_status == 'cancelled' && strlen(get_fci_settings('wa-text-cancelled')) > 1) {
                    $text = get_fci_settings('wa-text-cancelled');
                }
                if ($order_status == 'failed' && strlen(get_fci_settings('wa-text-failed')) > 1) {
                    $text = get_fci_settings('wa-text-failed');
                }
            }
        }



        return $this->replace_body($text);
    }

    public function replace_body($text)
    {
        $customer = new FCI_Customer_Detail($this->order_id, null);
        $order = wc_get_order($this->order_id);

        $search = [
            '{{invoice-url}}',
            '{{invoice-short-url}}',
            '{{phone}}',
            '{{email}}',
            '{{order-date}}',
            '{{payment-method}}',
            '{{transaction-id}}',
            '{{meli-code}}',
            '{{shipping-method}}',
            '{{order-id}}',
            '{{order-status}}',
            '{{products}}',
            '{{address}}',
            '{{full-name}}',
            '{{postcode}}',
            '{{total-amount}}',
            '{{discount-amount}}',
            '{{refunded-amount}}',
            '{{total-items}}',
            '{{payment-link}}',
            '{{tax-amount}}',
            '{{shipping-amount}}',
            '{{final-amount}}',
        ];
        $replace = [
            FCI_Helper::base_url() .'?action=fci-show&type=invoice&order-id=' . FCI_Helper::create_order_id($this->order_id, 'invoice') . '&wc=' . $order->get_order_key(),
            FCI_Helper::base_url() . '?action=s&&order-id=' . FCI_Helper::create_order_id($this->order_id, 'invoice'),
            $customer->get_phone(),
            $customer->get_email(),
            (new FCI_Customer_Detail($this->order_id, 'sms'))->get_order_date(),
            $customer->get_payment_method(),
            $customer->get_transaction_id(),
            $customer->get_national_id(),
            $customer->get_shipping_method(),
            (new FCI_Order_Detail($this->order_id, 'sms'))->get_order_id(),
            wc_get_order_status_name($order->get_status()),
            html_entity_decode(strip_tags((new FCI_Products_Table($this->order_id, 'sms'))->get_list(false)), ENT_QUOTES, 'UTF-8'),
            $customer->get_address(),
            $customer->get_full_name(),
            $customer->get_postal_code(),
            html_entity_decode(strip_tags(wc_price($order->get_subtotal())), ENT_QUOTES, 'UTF-8'),
            html_entity_decode(strip_tags(wc_price($order->get_total_discount())), ENT_QUOTES, 'UTF-8'),
            html_entity_decode(strip_tags(wc_price($order->get_total_refunded())), ENT_QUOTES, 'UTF-8'),
            $order->get_item_count(),
            $order->get_checkout_payment_url(),
            html_entity_decode(strip_tags(wc_price($order->get_total_tax())), ENT_QUOTES, 'UTF-8'),
            html_entity_decode(strip_tags(wc_price($order->get_shipping_total())), ENT_QUOTES, 'UTF-8'),
            html_entity_decode(strip_tags(wc_price($order->get_total())), ENT_QUOTES, 'UTF-8'),
        ];

        return str_replace($search, $replace, $text);
    }
}
