<?php
/*
Plugin Name: My Custom Plugin
Description: این پلاگین برای اجرا و توقف اسکریپت‌های پایتون و مشاهده لاگ‌ها می‌باشد.
Version: 1.0
Author: HDM_Tech_Team
*/

add_action('admin_menu', function() {
    add_menu_page(
        'اجرای کرالر',            // عنوان صفحه
        'کرالر',                  // عنوان منو
        'manage_options',         // دسترسی
        'run-crawler',            // اسلاگ
        'run_crawler_page',       // تابع
        'dashicons-update',       // آیکون
        6                         // موقعیت
    );
});


// صفحه اجرا برای کرالر
function run_crawler_page() {
    if (isset($_POST['run_crawler'])) {
        $categories = get_field('category_list', 'option'); // خواندن دسته‌بندی‌ها
        if (!$categories) {
            echo '<p>هیچ دسته‌بندی‌ای یافت نشد.</p>';
            return;
        }

        foreach ($categories as $category) {
            if (!empty($category['link']) && !empty($category['categor_item'])) {
                $url = 'https://berozkala.com' . $category['link'];
                $category_id = $category['categor_item'];
                $command = 'ssh -i /home/kharidstore/.ssh/id_rsa root@37.27.189.211 "/usr/bin/python3.10 /root/crawler/script.py ' 
                           . escapeshellarg($url) . ' ' . escapeshellarg($category_id) . '"';
                $output = shell_exec($command . ' 2>&1');
                echo '<pre>' . $output . '</pre>';
            }
        }
    }

    echo '<form method="post">';
    echo '<button type="submit" name="run_crawler" class="button button-primary">اجرای کرالر</button>';
    echo '</form>';
}

// زمان‌بندی کران جاب برای اجرای کرالر هر 4 ساعت
add_filter('cron_schedules', function($schedules) {
    $schedules['four_hours'] = array(
        'interval' => 4 * 60 * 60, // هر 4 ساعت
        'display'  => __('هر 4 ساعت')
    );
    return $schedules;
});

if (!wp_next_scheduled('run_crawler_job')) {
    wp_schedule_event(time(), 'four_hours', 'run_crawler_job');
}

add_action('run_crawler_job', 'run_crawler_task');

function run_crawler_task() {
    $categories = get_field('category_list', 'option'); // خواندن دسته‌بندی‌ها
    if (!$categories) {
        error_log('هیچ دسته‌بندی‌ای یافت نشد.');
        return;
    }

    foreach ($categories as $category) {
        if (!empty($category['link']) && !empty($category['categor_item'])) {
            $url = 'https://berozkala.com' . $category['link'];
            $category_id = $category['categor_item'];
            $command = 'ssh -i /home/kharidstore/.ssh/id_rsa root@37.27.189.211 "/usr/bin/python3.10 /root/crawler/script.py ' 
                       . escapeshellarg($url) . ' ' . escapeshellarg($category_id) . '"';
            shell_exec($command . ' 2>&1');
        }
    }
}

// اجرای کرالر از طریق Ajax
add_action('wp_ajax_run_crawler', 'run_crawler_ajax');

function run_crawler_ajax() {
    $categories = get_field('category_list', 'option'); // خواندن دسته‌بندی‌ها
    if (!$categories) {
        wp_send_json_error('هیچ دسته‌بندی‌ای یافت نشد.');
        return;
    }

    $results = [];
    foreach ($categories as $category) {
        if (!empty($category['link']) && !empty($category['categor_item'])) {
            $url = 'https://berozkala.com' . $category['link'];
            $category_id = $category['categor_item'];
            $command = 'ssh -i /home/kharidstore/.ssh/id_rsa root@37.27.189.211 "/usr/bin/python3.10 /root/crawler/script.py ' 
                       . escapeshellarg($url) . ' ' . escapeshellarg($category_id) . '"';
            $output = shell_exec($command . ' 2>&1');
            $results[] = [
                'category_id' => $category_id,
                'output' => $output,
            ];
        }
    }

    wp_send_json_success($results);
}