<?php

// جلوگیری از دسترسی مستقیم
if (!defined('ABSPATH')) {
    exit;
}
require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
use Sunra\PhpSimple\HtmlDomParser;
class Berozkala_Crawler {
    public static function init() {
        add_action('woocommerce_loaded', [__CLASS__, 'load_functions']);
    }

    public static function load_functions() {

        fetch_category_products();
        fetch_product_details();
        get_html();
        parse_category_html();
        apply_price_markup();
    }


    private $base_url = 'https://berozkala.com'; // دامنه سایت


//    public function fetch_category_products($category_url) {
//        //berozkala_log("Fetching category page: $category_url");
//
//        // دریافت HTML صفحه
//        $html = $this->get_html($category_url);
//        if (!$html) {
//            //berozkala_log("Failed to fetch category page: $category_url");
//            return [];
//        }
//
//        //berozkala_log("Successfully fetched category page: $category_url");
//
//        // پردازش HTML
//        require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
//        $dom = Sunra\PhpSimple\HtmlDomParser::str_get_html($html);
//
//        if (!$dom) {
//            //berozkala_log("Failed to parse HTML.");
//            return [];
//        }
//
//        $products = [];
//
//        // استخراج و پردازش محصولات یکی‌یکی
//        foreach ($dom->find('ul.products li.item div.item-area') as $product_area) {
//            $link_tag = $product_area->find('a.product-image', 0);
//            $title_tag = $product_area->find('div.product-detail-area h3 a', 0);
//            $price_tag = $product_area->find('span.price ins span.kalastore-price', 0);
//            $image_tag = $product_area->find('.product-image img', 0);
//
//            // لینک و ID محصول
//            $product_url = $this->base_url . $link_tag->href;
//            preg_match('/\/product\/(\d+)\//', $link_tag->href, $matches);
//            $product_id = $matches[1] ?? 'Unknown';
//
//            // اطلاعات محصول
//            $product = [
//                'title' => trim($title_tag->plaintext ?? 'Unknown'),
//                'price' => str_replace(',', '', $price_tag->plaintext ?? 0),
//                'link'  => $product_url,
//                'id'    => $product_id,
//                'image' => $image_tag->src ?? null, // اضافه کردن تصویر
//            ];
//
//            // ذخیره در آرایه محصولات
//            $products[] = $product;
//
//            // نمایش و ثبت لاگ برای هر محصول
//            //berozkala_log("Processed product: " . json_encode($product));
//
//            // اضافه کردن استراحت کوتاه برای جلوگیری از فشار زیاد به سرور
//            usleep(500000); // 0.5 ثانیه
//        }
//
//        //berozkala_log("Finished processing all products.");
//
//        return $products;
//    }


//    Edit Before Skip Category
//    public function fetch_category_products($category_url) {
//        berozkala_log("Fetching category page: $category_url");
//
//        // دریافت HTML صفحه
//        $html = $this->get_html($category_url);
//        if (!$html) {
//            error_log("Failed to fetch category page: $category_url");
//            return [];
//        }
//
//        error_log("Successfully fetched category page: $category_url");
//
//        // بررسی صفحه بعدی
//        $has_next_page = self::has_next_page($html);
//
//        // پردازش HTML
//        require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
//        $dom = Sunra\PhpSimple\HtmlDomParser::str_get_html($html);
//
//        if (!$dom) {
//            berozkala_log("Failed to parse HTML.");
//            return [];
//        }
//
//        $products = [];
//
//        // استخراج و پردازش محصولات یکی‌یکی
//        foreach ($dom->find('ul.products li.item div.item-area') as $product_area) {
//            $link_tag = $product_area->find('a.product-image', 0);
//            $title_tag = $product_area->find('div.product-detail-area h3 a', 0);
//            $price_tag = $product_area->find('span.price ins span.kalastore-price', 0);
//            $image_tag = $product_area->find('.product-image img', 0);
//
//            // لینک و ID محصول
//            $product_url = $this->base_url . $link_tag->href;
//            preg_match('/\/product\/(\d+)\//', $link_tag->href, $matches);
//            $product_id = $matches[1] ?? 'Unknown';
//
//            // اطلاعات محصول
//            $product = [
//                'title' => trim($title_tag->plaintext ?? 'Unknown'),
//                'price' => str_replace(',', '', $price_tag->plaintext ?? 0),
//                'link'  => $product_url,
//                'id'    => $product_id,
//                'image' => $image_tag->src ?? null,
//            ];
//
//            // ذخیره در آرایه محصولات
//            $products[] = $product;
//
//            // ثبت لاگ
//            error_log("Processed product: " . json_encode($product));
//
//            usleep(500000); // استراحت کوتاه برای جلوگیری از فشار زیاد به سرور
//        }
//
//        berozkala_log("Finished processing products for category page.");
//
//        return ['products' => $products, 'has_next_page' => $has_next_page];
//    }

//    public function fetch_category_products($category_url) {
//        berozkala_log("Fetching category page: $category_url");
//
//        $html = $this->get_html($category_url);
//        if (!$html) {
//            berozkala_log("Failed to fetch category page: $category_url");
//            return [];
//        }
//
//        berozkala_log("Successfully fetched category page: $category_url");
//
//        $has_next_page = self::has_next_page($html);
//
//        require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
//        $dom = Sunra\PhpSimple\HtmlDomParser::str_get_html($html);
//        if (!$dom) {
//            berozkala_log("Failed to parse HTML.");
//            return [];
//        }
//
//        $products = [];
//
//        foreach ($dom->find('ul.products li.item div.item-area') as $product_area) {
//            $link_tag  = $product_area->find('a.product-image', 0);
//            $title_tag = $product_area->find('div.product-detail-area h3 a', 0);
//            $price_tag = $product_area->find('span.price ins span.kalastore-price', 0);
//            $image_tag = $product_area->find('.product-image img', 0);
//
//            $product_url = $this->base_url . $link_tag->href;
//            preg_match('/\/product\/(\d+)\//', $link_tag->href, $matches);
//            $product_id = $matches[1] ?? 'Unknown';
//
//            $price = str_replace(',', '', $price_tag->plaintext ?? 0);
//            if (floatval($price) == 0) {
//                berozkala_log("محصول بدون قیمت یافت شد. رد کردن دسته‌بندی فعلی.");
//                // علامت خاص برای اینکه دسته‌بندی باید رد بشه
//                return ['products' => [], 'has_next_page' => false, 'skip_category' => true];
//            }
//
//            $product = [
//                'title' => trim($title_tag->plaintext ?? 'Unknown'),
//                'price' => $price,
//                'link'  => $product_url,
//                'id'    => $product_id,
//                'image' => $image_tag->src ?? null,
//            ];
//
//            $products[] = $product;
//
//            usleep(500000); // کمی استراحت برای فشار کمتر
//        }
//
//        berozkala_log("Finished processing products for category page.");
//
//        return ['products' => $products, 'has_next_page' => $has_next_page];
//    }

    public function fetch_category_products($category_url) {
        berozkala_log("Fetching category page: $category_url");

        $html = $this->get_html($category_url);
        if (!$html) {
            berozkala_log("Failed to fetch category page: $category_url");
            return [];
        }

        berozkala_log("Successfully fetched category page: $category_url");

        $has_next_page = self::has_next_page($html);

        require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
        $dom = Sunra\PhpSimple\HtmlDomParser::str_get_html($html);
        if (!$dom) {
            error_log("Failed to parse HTML.");
            return [];
        }

        $products = [];
        $should_skip_category = false;

        foreach ($dom->find('ul.products li.item div.item-area') as $product_area) {
            $link_tag  = $product_area->find('a.product-image', 0);
            $title_tag = $product_area->find('div.product-detail-area h3 a', 0);
            $price_tag = $product_area->find('span.price ins span.kalastore-price', 0);
            $image_tag = $product_area->find('.product-image img', 0);

            $product_url = $this->base_url . $link_tag->href;
            preg_match('/\/product\/(\d+)\//', $link_tag->href, $matches);
            $product_id = $matches[1] ?? 'Unknown';

            $price = str_replace(',', '', $price_tag->plaintext ?? 0);
            if (floatval($price) == 0) {
                $should_skip_category = true;
            }

            $product = [
                'title' => trim($title_tag->plaintext ?? 'Unknown'),
                'price' => $price,
                'link'  => $product_url,
                'id'    => $product_id,
                'image' => $image_tag->src ?? null,
            ];
            error_log($product);
            $products[] = $product;

            usleep(500000); // استراحت برای فشار کمتر
        }

        berozkala_log("Finished processing products for category page.");

        return [
            'products' => $products,
            'has_next_page' => $has_next_page,
            'skip_category' => $should_skip_category
        ];
    }



    function fetch_product_details($url,$product_id) {
        berozkala_log("Fetching product details: $url");
        // دریافت HTML صفحه
        $html = file_get_contents($url);
        if (!$html) {
            berozkala_log("Failed to fetch product page: $url");
            return false;
        }

        require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
        $dom = Sunra\PhpSimple\HtmlDomParser::str_get_html($html);

        if (!$dom) {
            berozkala_log("Failed to parse product page: $url");
            return false;
        }

        // لاگ کردن بخشی از HTML صفحه برای دیباگ


        // 1. استخراج متغیرها (گارانتی و رنگ)
        $variations = [];
        foreach ($dom->find('input[type=hidden]') as $input) {
            $category = $input->getAttribute('data-attcat');
            $name = $input->getAttribute('data-attname');
            $value = preg_replace('/[^\d.]/', '', $input->value);

            if ($category == '1') { // گارانتی
                $variations['warranty'][] = [
                    'name' => $name,
                    'price' => $value,
                ];
            } elseif ($category == '2') { // رنگ
                $variations['color'][] = [
                    'name' => $name,
                    'price' => $value,
                ];
            }
        }

        // لاگ کردن متغیرها
        if (!empty($variations)) {
//            //berozkala_log("Variations found: " . json_encode($variations));
        } else {
            //berozkala_log("No variations found.");
        }

        // 2. استخراج گالری
        $gallery = [];
        if ($dom->find('div.thumbnails img')) {
            foreach ($dom->find('div.thumbnails img') as $img) {
                $gallery[] = $img->src;
//                //berozkala_log("Found gallery image: " . $img->src);
            }
        }

        // لاگ کردن گالری
        if (!empty($gallery)) {
//            //berozkala_log("Gallery images found: " . json_encode($gallery));
        } else {
//            //berozkala_log("No gallery images found.");
        }


        // 3. استخراج ویژگی‌ها
        $attributes = [];
        if ($dom->find('table.shop_attributes tr.attribute_row')) {
            foreach ($dom->find('table.shop_attributes tr.attribute_row') as $row) {
                $name = trim($row->find('td.attribute_name', 0)->plaintext ?? '');
                $value = trim($row->find('td.attribute_value', 0)->plaintext ?? '');

                if ($name && $value) {
                    $attributes[] = [
                        'name' => $name,
                        'value' => $value,
                    ];
                    //berozkala_log("Found attribute: Name - $name, Value - $value");
                }
            }
        }


        $description = $dom->find("div#tab-description", 0); // شاخص صفر برای گرفتن فقط اولین مورد
        $tab_additional_information = $dom->find("div#tab-additional_information", 0); // شاخص صفر برای گرفتن فقط اولین مورد

        if ($description) {
            $description_inner = $description->innertext; // یا ->plaintext برای فقط متن
        } else {
            $description_inner = "";
        }
        if ($tab_additional_information) {
            $tab_additional_information_inner =  $tab_additional_information->innertext; // یا ->plaintext برای فقط متن
        } else {
            $tab_additional_information_inner = "";
        }

        $update = update_post_meta($product_id,'b__variations',$variations);
        $update = update_post_meta($product_id,'b_description',$description_inner);
        $update = update_post_meta($product_id,'b_information_inner',$tab_additional_information_inner);
        // بازگرداندن اطلاعات استخراج شده
        return [
            'variations' => $variations,
            'gallery' => $gallery,
            'attributes' => $attributes,
            'description' => $description_inner,
        ];


    }

    private function get_html($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $html = curl_exec($ch);
        curl_close($ch);

        return $html;
    }

    private function parse_category_html($html) {
        //berozkala_log("Parsing category HTML...");
        require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
        $dom = HtmlDomParser::str_get_html($html);

        $products = [];
        foreach ($dom->find('ul.products li.item div.item-area') as $product_area) {
            $link_tag = $product_area->find('a.product-image', 0);
            $title_tag = $product_area->find('div.product-detail-area h3 a', 0);
            $price_tag = $product_area->find('span.price ins span.kalastore-price', 0);

            // لینک و ID محصول
            $product_url = $this->base_url . $link_tag->href;
            preg_match('/\/product\/(\d+)\//', $link_tag->href, $matches);
            $product_id = $matches[1] ?? 'Unknown';

            //berozkala_log("Processing product: $product_url");

            $products[] = [
                'title' => trim($title_tag->plaintext ?? 'Unknown'),
                'price' => $this->apply_price_markup(str_replace(',', '', $price_tag->plaintext ?? 0)),
                'link'  => $product_url,
                'id'    => $product_id,
            ];
        }

        //berozkala_log("Finished parsing category HTML.");
        return $products;
    }

    private function apply_price_markup($price, $markup = 12) {
        return round($price * (1 + $markup / 100), 2);
    }

//    function has_next_page($category_url) {
//        // دریافت HTML صفحه
//        $html = file_get_contents($category_url); // فرض بر اینکه get_html استاتیک نیست
//        if (!$html) {
//            berozkala_log("Failed to fetch HTML for pagination check: $category_url");
//            return false;
//        }
//
//        // پردازش HTML با استفاده از Simple HTML DOM
//        require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
//        $dom = Sunra\PhpSimple\HtmlDomParser::str_get_html($html);
//
//        if (!$dom) {
//            berozkala_log("Failed to parse HTML for pagination check.");
//            return false;
//        }
//
//        // بررسی وجود لینک صفحه بعد
//        $next_page_link = $dom->find('ul.pagination li a[rel=next]', 0);
//        if ($next_page_link) {
//            berozkala_log("Next page found: " . $next_page_link->href);
//            return true;
//        }
//
//        berozkala_log("No next page found.");
//        return false;
//    }

    public static function has_next_page($html) {
        require_once BEROZKALA_PLUGIN_DIR . 'includes/Sunra/PhpSimple/HtmlDomParser.php';
        $dom = Sunra\PhpSimple\HtmlDomParser::str_get_html($html);

        if (!$dom) {
            berozkala_log("Failed to parse HTML for pagination.");
            return false;
        }

        // جستجوی لینک صفحه بعدی
        $next_page_link = $dom->find('ul.pagination li a[rel=next]', 0);

        if ($next_page_link) {
            berozkala_log("Next page found: " . $next_page_link->href);
            return true;
        } else {
            berozkala_log("No next page found.");
            return false;
        }
    }

}



// اجازه سفارش حتی اگر محصول ناموجود باشه و موجودی نداشته باشه
add_filter('woocommerce_product_is_in_stock', '__return_true');

// حذف بررسی موجودی در زمان افزودن به سبد خرید
add_filter('woocommerce_add_to_cart_validation', 'hdm_skip_stock_validation', 10, 4);
function hdm_skip_stock_validation($passed, $product_id, $quantity, $variation_id = null) {
    return true;
}

add_filter('woocommerce_is_purchasable', 'hdm_block_zero_price_products', 20, 2);
function hdm_block_zero_price_products($purchasable, $product) {
    if ($product->get_price() <= 0) {
        return false;
    }
    return $purchasable;
}

// نمایش پیام هشدار برای قیمت صفر
add_action('woocommerce_single_product_summary', 'hdm_show_zero_price_message', 31);
function hdm_show_zero_price_message() {
    global $product;
    if ($product->get_price() <= 0) {
        echo '<p style="color: red;">این محصول قیمت ندارد و قابل سفارش نیست.</p>';
    }
}


add_filter( 'woocommerce_product_single_add_to_cart_text', 'hdm_enable_ajax_add_to_cart' );
function hdm_enable_ajax_add_to_cart( $text ) {
    // کلاس ajax-add-to-cart رو به دکمه اضافه می‌کنه
    add_filter( 'woocommerce_product_add_to_cart_url', function( $url ) {
        return $url;
    }, 10, 1 );

    return $text;
}

// اضافه کردن کلاس ajax به دکمه
add_filter( 'woocommerce_loop_add_to_cart_args', 'hdm_ajax_add_to_cart_class' );
function hdm_ajax_add_to_cart_class( $args ) {
    $args['class'] .= ' ajax_add_to_cart';
    return $args;
}

add_action( 'wp_enqueue_scripts', 'hdm_force_load_wc_cart_fragments', 99 );
function hdm_force_load_wc_cart_fragments() {
    if (class_exists('WooCommerce')) {
        wp_enqueue_script('wc-cart-fragments');
    }

}


// تغییر نمایش قیمت محصولات متغیر در ووکامرس
add_filter( 'woocommerce_format_price_range', 'hdm_custom_price_range', 10, 3 );
function hdm_custom_price_range( $price, $from, $to ) {
    return 'از ' . wc_price($from) . '   ' . wc_price($to);
}