<?php
/*
Plugin Name: کرالر خرید استور
Plugin URI: https://example.com
Description: کرالر خرید استور از وب سایت به روز کالا
Version: 1.0
Author: HDM
Author URI: https://example.com
License: GPL2
Requires Plugins: woocommerce
*/

// جلوگیری از دسترسی مستقیم به فایل
if (!defined('ABSPATH')) {
    exit;
}


define('BEROZKALA_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('BEROZKALA_PLUGIN_URL', plugin_dir_url(__FILE__));
add_action('woocommerce_init', function() {
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', function() {
            echo '<div class="error"><p>WooCommerce باید فعال باشد تا این پلاگین کار کند.</p></div>';
        });
        return;
    }
    require_once BEROZKALA_PLUGIN_DIR . 'includes/class-crawler.php';
    require_once BEROZKALA_PLUGIN_DIR . 'includes/class-wc-integration.php';
    // اجرای کدهای ووکامرس بعد از اطمینان از بارگذاری
    Berozkala_WP_Integration::init();
    Berozkala_Crawler::init();
});

require_once BEROZKALA_PLUGIN_DIR . 'includes/class-crawler.php';
require_once BEROZKALA_PLUGIN_DIR . 'includes/class-wc-integration.php';
require_once BEROZKALA_PLUGIN_DIR . 'includes/CoreFunction.php';

function berozkala_crawler_activate() {
    // کدهایی که هنگام فعال‌سازی اجرا می‌شود
}
register_activation_hook(__FILE__, 'berozkala_crawler_activate');

function berozkala_crawler_deactivate() {
    // کدهایی که هنگام غیرفعال‌سازی اجرا می‌شود
}
register_deactivation_hook(__FILE__, 'berozkala_crawler_deactivate');



// افزودن صفحه به منوی مدیریت
add_action('admin_menu', 'berozkala_add_admin_menu');
function berozkala_add_admin_menu() {
    add_menu_page(
        'کرالر خرید استور',       // عنوان صفحه
        'کرالر خرید استور',       // عنوان منو
        'manage_options',          // سطح دسترسی
        'berozkala-crawler',       // اسلاگ منو
        'berozkala_crawler_page',  // تابعی که صفحه را نمایش می‌دهد
        'dashicons-update',        // آیکون منو
        100                        // موقعیت منو
    );
}

// محتوای صفحه تنظیمات
function berozkala_crawler_page() {
    ?>
    <div class="wrap">
        <h1>کرالر خرید استور</h1>
        <h2>عملیات ها</h2>

        <form method="post" action="">
            <?php wp_nonce_field('start_crawler_action', 'start_crawler_nonce'); ?>
            <input type="hidden" name="action" value="start_crawler">
            <button type="submit" class="button button-primary">شروع دستی کرالر (تنها درصورتی که کرالر به صورت خودکار غیر فعال بود.)</button>
        </form>

        <textarea rows="20" style="width:100%;"><?php echo esc_textarea(get_option('berozkala_crawler_logs', 'No logs yet.')); ?></textarea>
        <form method="post" action="">
            <?php wp_nonce_field('clear_logs_action', 'clear_logs_nonce'); ?>
            <input type="hidden" name="action" value="clear_logs">
            <button type="submit" class="button">حذف لاگ عملیات</button>
        </form>

        <?=berozkala_crawler_status()?>

    </div>
    <?php

}

add_action('admin_init', 'berozkala_handle_crawler_action');
function berozkala_handle_crawler_action() {
    if (
        isset($_POST['action']) &&
        $_POST['action'] === 'start_crawler' &&
        check_admin_referer('start_crawler_action', 'start_crawler_nonce')
    ) {
//        berozkala_start_crawler();
        berozkala_crawler_cron();
    }
}


function berozkala_log($message) {
    $upload_dir = wp_upload_dir();
    $log_file = trailingslashit($upload_dir['basedir']) . 'crawler_log.txt';

    $timestamp = date('Y-m-d H:i:s');
    $log_entry = "[$timestamp] $message\n";

    file_put_contents($log_file, $log_entry, FILE_APPEND | LOCK_EX);
}
function berozkala_clear_log_file() {
    $send_email = berozkala_email_log_and_clear();
    $upload_dir = wp_upload_dir();
    $log_file = trailingslashit($upload_dir['basedir']) . 'crawler_log.txt';

    if (file_exists($log_file)) {
        unlink($log_file);
    }
}
register_activation_hook(__FILE__, function() {
    if (!wp_next_scheduled('berozkala_hourly_log_clear')) {
        wp_schedule_event(time(), 'hourly', 'berozkala_hourly_log_clear');
    }
});
add_action('berozkala_hourly_log_clear', 'berozkala_clear_log_file');


add_action('admin_init', 'berozkala_handle_clear_logs');
function berozkala_handle_clear_logs() {
    if (
        isset($_POST['action']) &&
        $_POST['action'] === 'clear_logs' &&
        check_admin_referer('clear_logs_action', 'clear_logs_nonce')
    ) {
        update_option('berozkala_crawler_logs', '');
    }
}


add_filter('woocommerce_product_get_image', 'set_product_thumbnail_from_meta', 10, 2);

function set_product_thumbnail_from_meta($image, $product) {
    $thumbnail_url = get_post_meta($product->get_id(), 'b_product_thumbnail', true);

    if ($thumbnail_url) {
        return sprintf('<img src="%s" alt="%s" />', esc_url($thumbnail_url), esc_attr($product->get_name()));
    }

    return $image;
}

add_filter('woocommerce_product_get_gallery_image_ids', 'get_gallery_from_meta', 10, 2);

function get_gallery_from_meta($image_ids, $product) {
    $gallery = get_post_meta($product->get_id(), 'b_product_gallery', true);

    if (!empty($gallery)) {
        return array_map(function ($url) {
            // ایجاد ID مجازی برای تصاویر
            return $url;
        }, $gallery);
    }

    return $image_ids;
}


add_filter('cron_schedules', 'add_one_minute_cron_interval');
function add_one_minute_cron_interval($schedules) {
    $schedules['one_minute'] = [
        'interval' => 60, // زمان به ثانیه (۱ دقیقه)
        'display'  => __('Every One Minute'),
    ];
    return $schedules;
}

// ثبت کران جاب
if (!wp_next_scheduled('process_product_details_cron')) {
    wp_schedule_event(time(), 'one_minute', 'process_product_details_cron');
}

// هوک برای کران جاب
add_action('process_product_details_cron', 'process_product_details');


register_deactivation_hook(__FILE__, 'remove_process_product_details_cron');
function remove_process_product_details_cron() {
    $timestamp = wp_next_scheduled('process_product_details_cron');
    if ($timestamp) {
        wp_unschedule_event($timestamp, 'process_product_details_cron');
    }
}

function log_product_details_cron($message) {
    $log_file = __DIR__ . '/product_details_cron.log'; // مسیر فایل لاگ
    $timestamp = date('Y-m-d H:i:s');
    $formatted_message = "[$timestamp] $message" . PHP_EOL;
    file_put_contents($log_file, $formatted_message, FILE_APPEND);
}



//function process_product_details() {
//    berozkala_log("Cron Job Started");
//
//    $products = get_posts(array(
//        'post_type'  => 'product',
//        'meta_query' => array(
//                array(
//                    "key" => "b_price_update",
//                    "value" => "0",
//                    "compare" => ">"
//                )
//        ),
//        'posts_per_page' => 50,
//    ));
//
//    foreach ($products as $product) {
//        $product_id = $product->ID;
//        $product_url = get_post_meta($product_id, 'b_product_url', true);
//        $details = Berozkala_Crawler::fetch_product_details($product_url);
////        $sync = add_variations_CRON($product_id);
//        if ($details) {
//            Berozkala_WP_Integration::update_product_details($product_id, $details);
//            update_post_meta($product_id, 'b_product_single_sync', 1);
//            berozkala_log("Successfully updated product ID: $product_id");
//        } else {
//            berozkala_log("Failed to fetch details for Product ID: $product_id");
//        }
//    }
//
//    berozkala_log("Cron Job Finished");
//}

function log_product_sync_file($message) {
    $log_dir = WP_CONTENT_DIR . '/berozkala-logs';
    $log_file = $log_dir . '/product-sync.log';

    // ساخت پوشه اگر وجود نداشت
    if (!file_exists($log_dir)) {
        if (!wp_mkdir_p($log_dir)) {
            error_log("❌ [Berozkala Log] پوشه لاگ ساخته نشد: $log_dir");
            return;
        }
    }

    $timestamp = current_time('Y-m-d H:i:s');
    $log_line = "[$timestamp] $message" . PHP_EOL;

    if (file_put_contents($log_file, $log_line, FILE_APPEND) === false) {
        error_log("❌ [Berozkala Log] ذخیره لاگ ناموفق بود: $log_file");
    }
}

function process_product_details() {
    // بررسی وجود قفل برای جلوگیری از اجرای هم‌زمان
    if (get_transient('berozkala_product_sync_lock')) {
        log_product_sync_file("⏱ در حال حاضر یک اجرای دیگر در جریان است. اجرا متوقف شد.");
        return;
    }

    // ست‌کردن قفل به مدت 5 دقیقه
    set_transient('berozkala_product_sync_lock', true, 5 * MINUTE_IN_SECONDS);

    $offset = get_option('berozkala_single_product_offset', 0);
    $limit  = 10;

    log_product_sync_file("🔁 شروع پردازش از offset: $offset");

    $products = get_posts(array(
        'post_type'      => 'product',
        'posts_per_page' => $limit,
        'offset'         => $offset,
        'orderby'        => 'ID',
        'order'          => 'ASC',
        'meta_query'     => array(
            array(
                'key'     => 'b_price_update',
                'value'   => '0',
                'compare' => '>'
            )
        )
    ));

    if (empty($products)) {
        log_product_sync_file("✅ همه محصولات پردازش شدند. offset به صفر برگشت.");
        update_option('berozkala_single_product_offset', 0);
        delete_transient('berozkala_product_sync_lock'); // حذف قفل
        return;
    }

    foreach ($products as $product) {
        $product_id  = $product->ID;
        $product_url = get_post_meta($product_id, 'b_product_url', true);
        log_product_sync_file("📦 بررسی محصول ID: $product_id");

        $details = Berozkala_Crawler::fetch_product_details($product_url,$product_id);
        log_product_sync_file('وریشن'.json_encode($details['variations']));
        if ($details) {
            Berozkala_WP_Integration::update_product_details($product_id, $details);
            update_post_meta($product_id, 'b_product_single_sync', 1);
            log_product_sync_file("✅ محصول $product_id با موفقیت آپدیت شد.");
        } else {
            log_product_sync_file("❌ دریافت اطلاعات محصول $product_id ناموفق بود.");
        }
    }

    update_option('berozkala_single_product_offset', $offset + $limit);
    log_product_sync_file("🔚 پایان پردازش دسته از offset $offset تا " . ($offset + $limit - 1));

    // حذف قفل
    delete_transient('berozkala_product_sync_lock');
}



//function process_product_details() {
//    log_product_details_cron("Cron Job Started");
//
//    $products = get_posts(array(
//        'post_type'  => 'product',
//        'meta_query' => array(
//            array(
//                "key" => "b_price_update",
//                "value" => "0",
//                "compare" => ">"
//            )
//        ),
//        'posts_per_page' => 50,
//    ));
//
//    foreach ($products as $product) {
//        $product_id = $product->ID;
//        $product_url = get_post_meta($product_id, 'b_product_url', true);
//        $details = Berozkala_Crawler::fetch_product_details($product_url);
////        $sync = add_variations_CRON($product_id);
//        if ($details) {
//            Berozkala_WP_Integration::update_product_details($product_id, $details);
//            update_post_meta($product_id, 'b_product_single_sync', 1);
//            log_product_details_cron("Successfully updated product ID: $product_id");
//        } else {
//            log_product_details_cron("Failed to fetch details for Product ID: $product_id");
//        }
//    }
//
//    log_product_details_cron("Cron Job Finished");
//}




add_filter('wp_image_editors', function ($editors) {
    if (!empty($_SERVER['HTTP_REFERER']) && strpos($_SERVER['HTTP_REFERER'], 'https://berozkala.com') !== false) {
        return []; // غیرفعال کردن ویرایشگر تصویر برای تصاویر به‌روزکالا
    }
    return $editors;
});




add_filter('wp_get_attachment_url', 'remove_prefix_for_berozkala_images', 10, 2);
add_filter('wp_get_attachment_image_src', 'remove_prefix_for_berozkala_image_src', 10, 2);
//add_filter('the_content', 'remove_prefix_from_images_in_content', 10);

function remove_prefix_for_berozkala_images($url, $attachment_id) {
    $prefix_to_remove = 'https://kharidstore.com/wp-content/uploads/';
    $berozkala_domain = 'berozkala.com';

    // بررسی وجود آدرس اضافی و دامنه berozkala
    if (strpos($url, $berozkala_domain) !== false && strpos($url, $prefix_to_remove) === 0) {
        $url = str_replace($prefix_to_remove, '', $url);
    }

    return $url;
}

function remove_prefix_for_berozkala_image_src($image_src, $attachment_id) {
    $prefix_to_remove = 'https://kharidstore.com/wp-content/uploads/';
    $berozkala_domain = 'berozkala.com';

    // بررسی وجود آدرس اضافی و دامنه berozkala
    if (!empty($image_src[0]) && strpos($image_src[0], $berozkala_domain) !== false && strpos($image_src[0], $prefix_to_remove) === 0) {
        $image_src[0] = str_replace($prefix_to_remove, '', $image_src[0]);
    }

    return $image_src;
}

function remove_prefix_from_images_in_content($content) {
    $prefix_to_remove = 'https://kharidstore.com/wp-content/uploads/';
    $berozkala_domain = 'berozkala.com';

    // بررسی و حذف آدرس اضافی از محتوای نوشته‌ها و صفحات
    if (strpos($content, $berozkala_domain) !== false && strpos($content, $prefix_to_remove) !== false) {
        $content = str_replace($prefix_to_remove, '', $content);
    }

    return $content;
}
add_filter('post_thumbnail_html', 'use_b_product_thumbnail_as_image', 10, 5);

function use_b_product_thumbnail_as_image($html, $post_id, $post_thumbnail_id, $size, $attr) {
    // بررسی اینکه آیا این درخواست برای یک محصول ووکامرس است
    if ('product' === get_post_type($post_id)) {
        // دریافت مقدار متای b_product_thumbnail
        $custom_thumbnail_url = get_post_meta($post_id, 'b_product_thumbnail', true);

        // اگر متای b_product_thumbnail مقدار داشت، تصویر محصول را تغییر دهیم
        if (!empty($custom_thumbnail_url)) {
            $custom_img = '<img src="' . esc_url($custom_thumbnail_url) . '" class="attachment-' . esc_attr($size) . ' size-' . esc_attr($size) . '" alt="" />';

            return $custom_img;
        }
    }

    // اگر متا مقدار نداشت، تصویر پیش‌فرض را بازگردانیم
    return $html;
}

// Ediiit 1
function add_variations_from_meta_to_product() {
    if (is_product()) {
        global $post;
        $product_id = $post->ID;
        $crawler_setting = get_field('crawler_setting', $product_id);
        if ($crawler_setting == "deactive") {
        }
        else {

            $_product_image_gallery = get_post_meta($post->ID, "_product_image_gallery", true);
            if ($_product_image_gallery == '') {

                $product_id = $post->ID;
                $gallery_urls = array(strtok(get_post_meta($post->ID, "b_product_thumbnail", true), "?"));

                $attachment_ids = [];

                foreach ($gallery_urls as $url) {
                    $attachment_id = attachment_url_to_postid($url);

                    if (!$attachment_id) {
                        $attachment_id = wp_insert_attachment([
                            'guid' => $url,
                            'post_mime_type' => 'image/jpeg',
                            'post_title' => basename($url),
                            'post_content' => '',
                            'post_status' => 'inherit',
                        ], $url);
                        if (!is_wp_error($attachment_id)) {
                            require_once(ABSPATH . 'wp-admin/includes/image.php');
                            wp_update_attachment_metadata($attachment_id, wp_generate_attachment_metadata($attachment_id, $url));
                        }
                    }

                    $attachment_ids[] = $attachment_id;
                }
                update_post_meta($product_id, '_product_image_gallery', implode(',', $attachment_ids));
            }


            // دریافت متای b_variations و b_price
            $variations_meta = get_post_meta($post->ID, 'b_variations', true);
            $b_price = floatval(get_post_meta($post->ID, 'b_price', true));

            // اگر متا خالی بود، خروج
            if (empty($variations_meta)) {
                return;
            }

            // unserialize کردن متا و بررسی اعتبار آن
            $variations = maybe_unserialize($variations_meta);
            if (!is_array($variations) || empty($variations)) {
                return;
            }

            // دریافت محصول
            $product = wc_get_product($post->ID);

            // اگر محصول موجود نبود، خروج
            if (!$product) {
                return;
            }

            // تغییر نوع محصول به 'variable'
            wp_set_object_terms($post->ID, 'variable', 'product_type');
            update_post_meta($post->ID, '_product_type', 'variable');

            // بازخوانی محصول به عنوان محصول متغیر
            $product = wc_get_product($post->ID);

            if (!$product || $product->get_type() !== 'variable') {
                error_log("محصول به متغیر تغییر نکرد. ID: $post->ID");
                return;
            }

            $product_attributes = $product->get_attributes();

            foreach ($variations as $attribute_name => $items) {
                // جایگزینی نام ویژگی خاص
                if ($attribute_name == 'warranty') {
                    $attribute_name = 'گارانتی';
                }
                if ($attribute_name == 'color') {
                    $attribute_name = 'رنگ';
                }

                // ساخت اسلاگ لاتین برای ویژگی
                $taxonomy = urldecode(sanitize_title($attribute_name));

                // بررسی و ثبت ویژگی در ووکامرس
                if (!taxonomy_exists($taxonomy)) {
                    $attribute_args = array(
                        'name' => urldecode($attribute_name), // نام فارسی برای نمایش
                        'slug' => $taxonomy, // اسلاگ لاتین برای ذخیره‌سازی
                        'type' => 'select',
                        'order_by' => 'menu_order',
                        'has_archives' => false,
                    );
                    wc_create_attribute($attribute_args);
                }

                // افزودن ویژگی به محصول
                $attribute_object = new WC_Product_Attribute();
                $attribute_object->set_name($taxonomy);
                $attribute_object->set_visible(true);
                $attribute_object->set_variation(true);

                $terms = [];
                foreach ($items as $item) {
                    $item['price'] = $item['price'] + $b_price;
                    if (isset($item['name']) && isset($item['price'])) {
                        $term_name = sanitize_text_field($item['name']);
                        $term_price = floatval($item['price']) * 1.12;
                        $terms[] = $term_name;

                        // افزودن مقدار به ویژگی
                        if (!term_exists($term_name, $taxonomy)) {
                            wp_insert_term($term_name, $taxonomy);
                        }

                        // ایجاد متغیر
                        $variation = new WC_Product_Variation();
                        $variation->set_parent_id($post->ID);
                        $variation->set_attributes([$taxonomy => $term_name]);
                        $variation->set_regular_price(floatval($term_price)); // تبدیل مقدار به عدد
                        $variation->set_stock_status('instock');
                        $variation->set_sku('SKU-' . uniqid());
                        $variation_id = $variation->save();

// بررسی قیمت پس از ذخیره
                        $variation_data = wc_get_product($variation_id);
                        error_log("Variation Created. ID: $variation_id, Term Name: $term_name, Term Price: $term_price, Saved Price: " . $variation_data->get_regular_price());


                    }
                }

                $attribute_object->set_options($terms);
                $product_attributes[$taxonomy] = $attribute_object;
            }

            // ذخیره ویژگی‌ها و متغیرها
            $product->set_attributes($product_attributes);
            $product->save();
            // ثبت لاگ برای بررسی
            error_log("ویژگی‌ها و متغیرها با موفقیت به محصول اضافه شدند. ID: {$post->ID}");
        }
    }
}
add_action('template_redirect', 'add_variations_from_meta_to_product');



// OLD Version Before grock
//function add_variations_CRON_New($id) {
//
//    $post = get_post($id);
//
//    // دریافت متای b_variations و b_price
//    $variations_meta = get_post_meta($post->ID, 'b_variations', true);
//    $b_price = floatval(get_post_meta($post->ID, 'b_price', true));
//
//    // اگر متا خالی بود، خروج
//    if (empty($variations_meta)) {
//        return;
//    }
//
//    // unserialize کردن متا و بررسی اعتبار آن
//    $variations = maybe_unserialize($variations_meta);
//    if (!is_array($variations) || empty($variations)) {
//        return;
//    }
//
//    // دریافت محصول
//    $product = wc_get_product($post->ID);
//
//    // اگر محصول موجود نبود، خروج
//    if (!$product) {
//        return;
//    }
//
//    // تغییر نوع محصول به 'variable'
//    wp_set_object_terms($post->ID, 'variable', 'product_type');
//    update_post_meta($post->ID, '_product_type', 'variable');
//
//    // بازخوانی محصول به عنوان محصول متغیر
//    $product = wc_get_product($post->ID);
//
//    if (!$product || $product->get_type() !== 'variable') {
//        error_log("محصول به متغیر تغییر نکرد. ID: $post->ID");
//        return;
//    }
//
//    $product_attributes = $product->get_attributes();
//
//    foreach ($variations as $attribute_name => $items) {
//        // جایگزینی نام ویژگی خاص
//        if ($attribute_name == 'warranty') {
//            $attribute_name = 'گارانتی';
//        }
//        if ($attribute_name == 'color') {
//            $attribute_name = 'رنگ';
//        }
//
//        // ساخت اسلاگ لاتین برای ویژگی
//        $taxonomy = urldecode(sanitize_title($attribute_name));
//
//        // بررسی و ثبت ویژگی در ووکامرس
//        if (!taxonomy_exists($taxonomy)) {
//            $attribute_args = array(
//                'name'         => urldecode($attribute_name), // نام فارسی برای نمایش
//                'slug'         => $taxonomy, // اسلاگ لاتین برای ذخیره‌سازی
//                'type'         => 'select',
//                'order_by'     => 'menu_order',
//                'has_archives' => false,
//            );
//            wc_create_attribute($attribute_args);
//        }
//
//        // افزودن ویژگی به محصول
//        $attribute_object = new WC_Product_Attribute();
//        $attribute_object->set_name($taxonomy);
//        $attribute_object->set_visible(true);
//        $attribute_object->set_variation(true);
//
//        $terms = [];
//        foreach ($items as $item) {
//            $item['price'] = $item['price'] + $b_price;
//            if (isset($item['name']) && isset($item['price'])) {
//                $term_name = sanitize_text_field($item['name']);
//                $term_price = ceil(floatval($item['price']) * 1.12);
//                $terms[] = $term_name;
//
//                // افزودن مقدار به ویژگی
//                if (!term_exists($term_name, $taxonomy)) {
//                    wp_insert_term($term_name, $taxonomy);
//                }
//
//                // ایجاد متغیر
//                $variation = new WC_Product_Variation();
//                $variation->set_parent_id($post->ID);
//                $variation->set_attributes([$taxonomy => $term_name]);
//                $variation->set_regular_price(floatval($term_price)); // تبدیل مقدار به عدد
//                $variation->set_stock_status('instock');
//                $variation->set_sku('SKU-' . uniqid());
//                $variation_id = $variation->save();
//
//// بررسی قیمت پس از ذخیره
//                $variation_data = wc_get_product($variation_id);
//                error_log("Variation Created. ID: $variation_id, Term Name: $term_name, Term Price: $term_price, Saved Price: " . $variation_data->get_regular_price());
//
//
//            }
//        }
//
//        $attribute_object->set_options($terms);
//        $product_attributes[$taxonomy] = $attribute_object;
//    }
//
//    // ذخیره ویژگی‌ها و متغیرها
//    $product->set_attributes($product_attributes);
//    $product->save();
//    $update = update_post_meta($post->ID,"b_sync_varation",1);
//    // ثبت لاگ برای بررسی
//    error_log("ویژگی‌ها و متغیرها با موفقیت به محصول اضافه شدند. ID: {$post->ID}");
//
//}

// Grock Version Is True But Title is incorect
//function add_variations_CRON_New($id) {
//    $post = get_post($id);
//    $variations_meta = get_post_meta($post->ID, 'b_variations', true);
//    $b_price = floatval(get_post_meta($post->ID, 'b_price', true));
//
//    if (empty($variations_meta)) {
//        error_log("متای b_variations خالی است. ID: $id");
//        return;
//    }
//
//    $variations = maybe_unserialize($variations_meta);
//    if (!is_array($variations) || empty($variations)) {
//        error_log("متای b_variations نامعتبر است. ID: $id");
//        return;
//    }
//
//    error_log("داده‌های b_variations: " . print_r($variations, true));
//
//    $product = wc_get_product($post->ID);
//    if (!$product) {
//        error_log("محصول یافت نشد. ID: $id");
//        return;
//    }
//
//    // پاکسازی کامل متغیرها و ویژگی‌ها
//    $existing_variations = $product->get_children();
//    foreach ($existing_variations as $variation_id) {
//        wp_delete_post($variation_id, true);
//        error_log("متغیر قدیمی $variation_id حذف شد.");
//    }
//    update_post_meta($post->ID, '_product_attributes', []);
//    $product->set_attributes([]);
//    $product->set_manage_stock(false);
//    $product->set_stock_status('instock');
//
//    // تنظیم محصول به نوع متغیر
//    wp_set_object_terms($post->ID, 'variable', 'product_type');
//    $product = wc_get_product($post->ID);
//    if (!$product || $product->get_type() !== 'variable') {
//        error_log("محصول به متغیر تغییر نکرد. ID: $id");
//        return;
//    }
//
//    $product_attributes = [];
//    $default_attributes = [];
//
//    // تابع تبدیل به لاتین
//    function transliterate_to_latin($text) {
//        $map = [
//            'گارانتی' => 'warranty',
//            'رنگ' => 'color',
//        ];
//        return isset($map[$text]) ? $map[$text] : sanitize_title($text);
//    }
//
//    foreach ($variations as $attribute_name => $items) {
//        if ($attribute_name == 'warranty') {
//            $attribute_name = 'گارانتی';
//        }
//        if ($attribute_name == 'color') {
//            $attribute_name = 'رنگ';
//        }
//
//        $taxonomy = 'pa_' . transliterate_to_latin($attribute_name);
//        error_log("تاکسونومی در حال پردازش: $taxonomy");
//
//        // اطمینان از وجود تاکسونومی
//        if (!taxonomy_exists($taxonomy)) {
//            $result = wc_create_attribute([
//                'name'         => $attribute_name,
//                'slug'         => $taxonomy,
//                'type'         => 'select',
//                'order_by'     => 'menu_order',
//                'has_archives' => false,
//            ]);
//            if (is_wp_error($result)) {
//                error_log("خطا در ایجاد تاکسونومی $taxonomy: " . $result->get_error_message());
//                continue;
//            }
//            error_log("تاکسونومی $taxonomy ایجاد شد.");
//        }
//
//        $attribute_object = new WC_Product_Attribute();
//        $attribute_object->set_name($taxonomy);
//        $attribute_object->set_visible(true);
//        $attribute_object->set_variation(true);
//
//        $term_slugs = [];
//        foreach ($items as $item) {
//            if (!isset($item['name']) || !isset($item['price'])) {
//                error_log("داده‌های نامعتبر برای آیتم: " . print_r($item, true));
//                continue;
//            }
//
//            $term_name = sanitize_text_field($item['name']);
//            $term_price = ceil(floatval($item['price'] + $b_price) * 1.12);
//
//            // افزودن یا دریافت term
//            $term = term_exists($term_name, $taxonomy);
//            if (!$term) {
//                $result = wp_insert_term($term_name, $taxonomy);
//                if (is_wp_error($result)) {
//                    error_log("خطا در افزودن مقدار '$term_name' به '$taxonomy': " . $result->get_error_message());
//                    continue;
//                }
//                $term = get_term_by('name', $term_name, $taxonomy);
//                error_log("مقدار '$term_name' به '$taxonomy' اضافه شد.");
//            } else {
//                $term = get_term_by('id', $term['term_id'], $taxonomy);
//                error_log("مقدار '$term_name' با ID {$term->term_id} در '$taxonomy' وجود دارد.");
//            }
//
//            if ($term) {
//                $term_slugs[] = $term->slug;
//
//                // لینک term به محصول
//                wp_set_object_terms($post->ID, $term->term_id, $taxonomy, true);
//                error_log("مقدار '$term_name' با ID {$term->term_id} به محصول $post->ID لینک شد.");
//
//                // ایجاد متغیر
//                $variation = new WC_Product_Variation();
//                $variation->set_parent_id($post->ID);
//                $variation->set_attributes([$taxonomy => $term->slug]); // استفاده از slug
//                $variation->set_regular_price(floatval($term_price));
//                $variation->set_manage_stock(true);
//                $variation->set_stock_quantity(10);
//                $variation->set_backorders('no');
//                $variation->set_stock_status('instock');
//                $variation->set_sku('SKU-' . $post->ID . '-' . uniqid());
//                $variation_id = $variation->save();
//
//                $variation_data = wc_get_product($variation_id);
//                $variation_attributes = $variation_data->get_attributes();
//                if (empty($variation_attributes) || !isset($variation_attributes[$taxonomy])) {
//                    error_log("خطا: ویژگی‌ها برای متغیر $variation_id ذخیره نشدند. ویژگی تنظیم‌شده: " . print_r([$taxonomy => $term->slug], true));
//                } else {
//                    error_log("متغیر $variation_id ایجاد شد. ویژگی‌ها: " . print_r($variation_attributes, true));
//                }
//            }
//        }
//
//        $attribute_object->set_options($term_slugs);
//        $product_attributes[$taxonomy] = $attribute_object;
//
//        // تنظیم پیش‌فرض
//        if (!empty($term_slugs)) {
//            $default_attributes[$taxonomy] = $term_slugs[0];
//            error_log("ویژگی پیش‌فرض برای $taxonomy: " . $term_slugs[0]);
//        }
//    }
//
//    // ذخیره ویژگی‌ها به‌صورت دستی
//    $product_attributes_data = [];
//    foreach ($product_attributes as $taxonomy => $attribute_object) {
//        $product_attributes_data[$taxonomy] = [
//            'name'         => $taxonomy,
//            'value'        => '',
//            'position'     => 0,
//            'is_visible'   => 1,
//            'is_variation' => 1,
//            'is_taxonomy'  => 1,
//        ];
//    }
//    update_post_meta($post->ID, '_product_attributes', $product_attributes_data);
//
//    // ذخیره محصول
//    $product->set_attributes($product_attributes);
//    $product->set_default_attributes($default_attributes);
//    $product->save();
//
//    update_post_meta($post->ID, 'b_sync_varation', 1);
//    error_log("ویژگی‌ها و متغیرها با موفقیت به محصول اضافه شدند. ID: $id");
//    error_log("محصول نهایی: نوع: " . $product->get_type() . ", ویژگی‌ها: " . print_r($product->get_attributes(), true));
//}


// Last Update With Grock


//function add_variations_CRON_New($id) {
//    $post = get_post($id);
//    $variations_meta = get_post_meta($post->ID, 'b_variations', true);
//    $b_price = floatval(get_post_meta($post->ID, 'b_price', true));
//
//    if (empty($variations_meta)) {
//        error_log("متای b_variations خالی است. ID: $id");
//        return;
//    }
//
//    $variations = maybe_unserialize($variations_meta);
//    if (!is_array($variations) || empty($variations)) {
//        error_log("متای b_variations نامعتبر است. ID: $id");
//        return;
//    }
//
//    error_log("داده‌های b_variations: " . print_r($variations, true));
//
//    $product = wc_get_product($post->ID);
//    if (!$product) {
//        error_log("محصول یافت نشد. ID: $id");
//        return;
//    }
//
//    // پاکسازی کامل متغیرها و ویژگی‌ها
//    $existing_variations = $product->get_children();
//    foreach ($existing_variations as $variation_id) {
//        wp_delete_post($variation_id, true);
//        error_log("متغیر قدیمی $variation_id حذف شد.");
//    }
//    update_post_meta($post->ID, '_product_attributes', []);
//    $product->set_attributes([]);
//    $product->set_manage_stock(false);
//    $product->set_stock_status('instock');
//
//    // تنظیم محصول به نوع متغیر
//    wp_set_object_terms($post->ID, 'variable', 'product_type');
//    $product = wc_get_product($post->ID);
//    if (!$product || $product->get_type() !== 'variable') {
//        error_log("محصول به متغیر تغییر نکرد. ID: $id");
//        return;
//    }
//
//    $product_attributes = [];
//    $default_attributes = [];
//    $all_terms = [];
//
//    // تابع تبدیل به لاتین
//    function transliterate_to_latin($text) {
//        $map = [
//            'گارانتی' => 'warranty',
//            'رنگ' => 'color',
//        ];
//        return isset($map[$text]) ? $map[$text] : sanitize_title($text);
//    }
//
//    // تابع برای دریافت slug سفارشی
//    function get_custom_term_slug($term_name, $taxonomy) {
//        $color_map = [
//            'سفید' => 'white',
//            'مشکی' => 'black',
//            'قرمز' => 'red',
//            // سایر رنگ‌ها
//        ];
//        if ($taxonomy === 'pa_color' && isset($color_map[$term_name])) {
//            return $color_map[$term_name];
//        }
//        return sanitize_title($term_name);
//    }
//
//    // جمع‌آوری تمام ویژگی‌ها و مقادیر
//    foreach ($variations as $attribute_name => $items) {
//        if ($attribute_name == 'warranty') {
//            $attribute_name = 'گارانتی';
//        }
//        if ($attribute_name == 'color') {
//            $attribute_name = 'رنگ';
//        }
//
//        $taxonomy = 'pa_' . transliterate_to_latin($attribute_name);
//        error_log("تاکسونومی در حال پردازش: $taxonomy");
//
//        if (!taxonomy_exists($taxonomy)) {
//            $result = wc_create_attribute([
//                'name'         => $attribute_name,
//                'slug'         => $taxonomy,
//                'type'         => 'select',
//                'order_by'     => 'menu_order',
//                'has_archives' => false,
//            ]);
//            if (is_wp_error($result)) {
//                error_log("خطا در ایجاد تاکسونومی $taxonomy: " . $result->get_error_message());
//                continue;
//            }
//            error_log("تاکسونومی $taxonomy ایجاد شد.");
//        }
//
//        $attribute_object = new WC_Product_Attribute();
//        $attribute_object->set_name($taxonomy);
//        $attribute_object->set_visible(true);
//        $attribute_object->set_variation(true);
//
//        $term_slugs = [];
//        $terms_data = [];
//        foreach ($items as $item) {
//            if (!isset($item['name']) || !isset($item['price'])) {
//                error_log("داده‌های نامعتبر برای آیتم: " . print_r($item, true));
//                continue;
//            }
//
//            $term_name = sanitize_text_field($item['name']);
//            $term_price = ceil(floatval($item['price'] + $b_price) * 1.12);
//            $term_slug = get_custom_term_slug($term_name, $taxonomy);
//
//            // افزودن یا دریافت term
//            $term = term_exists($term_name, $taxonomy);
//            if (!$term) {
//                $result = wp_insert_term($term_name, $taxonomy, ['slug' => $term_slug]);
//                if (is_wp_error($result)) {
//                    error_log("خطا در افزودن مقدار '$term_name' به '$taxonomy': " . $result->get_error_message());
//                    continue;
//                }
//                $term = get_term_by('name', $term_name, $taxonomy);
//                error_log("مقدار '$term_name' با slug '$term_slug' به '$taxonomy' اضافه شد.");
//            } else {
//                $term = get_term_by('id', $term['term_id'], $taxonomy);
//                error_log("مقدار '$term_name' با ID {$term->term_id} در '$taxonomy' وجود دارد.");
//            }
//
//            if ($term) {
//                $term_slugs[] = $term->slug;
//                $terms_data[] = [
//                    'slug'  => $term->slug,
//                    'name'  => $term_name,
//                    'price' => $term_price,
//                ];
//                wp_set_object_terms($post->ID, $term->term_id, $taxonomy, true);
//                error_log("مقدار '$term_name' با ID {$term->term_id} به محصول $post->ID لینک شد.");
//            }
//        }
//
//        $attribute_object->set_options($term_slugs);
//        $product_attributes[$taxonomy] = $attribute_object;
//        $all_terms[$taxonomy] = $terms_data;
//
//        // تنظیم پیش‌فرض
//        if (!empty($term_slugs)) {
//            $default_attributes[$taxonomy] = $term_slugs[0];
//            error_log("ویژگی پیش‌فرض برای $taxonomy: " . $term_slugs[0]);
//        }
//    }
//
//    // ذخیره ویژگی‌ها به‌صورت دستی
//    $product_attributes_data = [];
//    foreach ($product_attributes as $taxonomy => $attribute_object) {
//        $product_attributes_data[$taxonomy] = [
//            'name'         => $taxonomy,
//            'value'        => '',
//            'position'     => 0,
//            'is_visible'   => 1,
//            'is_variation' => 1,
//            'is_taxonomy'  => 1,
//        ];
//    }
//    update_post_meta($post->ID, '_product_attributes', $product_attributes_data);
//
//    // ایجاد تمام ترکیب‌های متغیرها
//    $combinations = [[]];
//    foreach ($all_terms as $taxonomy => $terms) {
//        $new_combinations = [];
//        foreach ($combinations as $combo) {
//            foreach ($terms as $term) {
//                $new_combo = $combo;
//                $new_combo[$taxonomy] = $term;
//                $new_combinations[] = $new_combo;
//            }
//        }
//        $combinations = $new_combinations;
//    }
//
//    // ایجاد متغیر برای هر ترکیب
//    foreach ($combinations as $combo) {
//        $variation = new WC_Product_Variation();
//        $variation->set_parent_id($post->ID);
//
//        $attributes = [];
//        $price = $b_price;
//        foreach ($combo as $taxonomy => $term) {
//            $attributes[$taxonomy] = $term['slug'];
//            $price += floatval($term['price']);
//        }
//
//        $variation->set_attributes($attributes);
//        $variation->set_regular_price(ceil($price * 1.12));
//        $variation->set_manage_stock(true);
//        $variation->set_stock_quantity(100); // افزایش موجودی
//        $variation->set_backorders('no');
//        $variation->set_stock_status('instock');
//        $variation->set_sku('SKU-' . $post->ID . '-' . uniqid());
//        $variation_id = $variation->save();
//
//        $variation_data = wc_get_product($variation_id);
//        $variation_attributes = $variation_data->get_attributes();
//        if (empty($variation_attributes)) {
//            error_log("خطا: ویژگی‌ها برای متغیر $variation_id ذخیره نشدند. ویژگی‌های تنظیم‌شده: " . print_r($attributes, true));
//        } else {
//            error_log("متغیر $variation_id ایجاد شد. ویژگی‌ها: " . print_r($variation_attributes, true));
//        }
//    }
//
//    // ذخیره محصول
//    $product->set_attributes($product_attributes);
//    $product->set_default_attributes($default_attributes);
//    $product->save();
//
//    update_post_meta($post->ID, 'b_sync_varation', 1);
//    error_log("ویژگی‌ها و متغیرها با موفقیت به محصول اضافه شدند. ID: $id");
//    error_log("محصول نهایی: نوع: " . $product->get_type() . ", ویژگی‌ها: " . print_r($product->get_attributes(), true));
//}



// New Version With Complate Method

//function add_variations_CRON_New($id) {
//    $post = get_post($id);
//    if (!$post) {
//        error_log("پست با ID $id یافت نشد.");
//        return;
//    }
//
//    $b_price_update = get_post_meta($post->ID, 'b_price_update', true);
//    $product = wc_get_product($post->ID);
//    if (!$product) {
//        error_log("محصول با ID $id یافت نشد.");
//        return;
//    }
//
//    // بررسی موجودی
//    if (empty($b_price_update) || $b_price_update == '0') {
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(0);
//        $product->set_stock_status('outofstock');
//        $product->save();
//        error_log("محصول با ID $id ناموجود شد (b_price_update: $b_price_update).");
//        return;
//    }
//
//    // ادامه برای محصولات موجود
//    $variations_meta = get_post_meta($post->ID, 'b_variations', true);
//    $b_price = floatval(get_post_meta($post->ID, 'b_price', true));
//
//    if (empty($variations_meta)) {
//        error_log("متای b_variations خالی است. ID: $id");
//        // همچنان موجود می‌مونه، اما متغیر نمی‌شه
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->save();
//        return;
//    }
//
//    $variations = maybe_unserialize($variations_meta);
//    if (!is_array($variations) || empty($variations)) {
//        error_log("متای b_variations نامعتبر است. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->save();
//        return;
//    }
//
//    error_log("داده‌های b_variations: " . print_r($variations, true));
//
//    // پاکسازی کامل متغیرها و ویژگی‌ها
//    $existing_variations = $product->get_children();
//    foreach ($existing_variations as $variation_id) {
//        wp_delete_post($variation_id, true);
//        error_log("متغیر قدیمی $variation_id حذف شد.");
//    }
//    update_post_meta($post->ID, '_product_attributes', []);
//    $product->set_attributes([]);
//
//    // تنظیم محصول به نوع متغیر
//    wp_set_object_terms($post->ID, 'variable', 'product_type');
//    $product = wc_get_product($post->ID);
//    if (!$product || $product->get_type() !== 'variable') {
//        error_log("محصول به متغیر تغییر نکرد. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->save();
//        return;
//    }
//
//    $product_attributes = [];
//    $default_attributes = [];
//    $all_terms = [];
//
//    // تابع تبدیل به لاتین
//    function transliterate_to_latin($text) {
//        $map = [
//            'گارانتی' => 'warranty',
//            'رنگ' => 'color',
//        ];
//        return isset($map[$text]) ? $map[$text] : sanitize_title($text);
//    }
//
//    // تابع برای دریافت slug سفارشی
//    function get_custom_term_slug($term_name, $taxonomy) {
//        $color_map = [
//            'سفید' => 'white',
//            'مشکی' => 'black',
//            'قرمز' => 'red',
//        ];
//        $warranty_map = [
//            'اصالت و سلامت فیزیکی بهمراه مهلت تست تحویل' => 'authenticity-test',
//            'اصالت وسلامت فیزیکی بهمراه یک هفته مهلت تست' => 'authenticity-one-week',
//        ];
//        if ($taxonomy === 'pa_color' && isset($color_map[$term_name])) {
//            return $color_map[$term_name];
//        }
//        if ($taxonomy === 'pa_warranty' && isset($warranty_map[$term_name])) {
//            return $warranty_map[$term_name];
//        }
//        return sanitize_title($term_name);
//    }
//
//    // جمع‌آوری تمام ویژگی‌ها و مقادیر
//    foreach ($variations as $attribute_name => $items) {
//        if ($attribute_name == 'warranty') {
//            $attribute_name = 'گارانتی';
//        }
//        if ($attribute_name == 'color') {
//            $attribute_name = 'رنگ';
//        }
//
//        $taxonomy = 'pa_' . transliterate_to_latin($attribute_name);
//        error_log("تاکسونومی در حال پردازش: $taxonomy");
//
//        if (!taxonomy_exists($taxonomy)) {
//            $result = wc_create_attribute([
//                'name'         => $attribute_name,
//                'slug'         => $taxonomy,
//                'type'         => 'select',
//                'order_by'     => 'menu_order',
//                'has_archives' => false,
//            ]);
//            if (is_wp_error($result)) {
//                error_log("خطا در ایجاد تاکسونومی $taxonomy: " . $result->get_error_message());
//                continue;
//            }
//            error_log("تاکسونومی $taxonomy ایجاد شد.");
//        }
//
//        $attribute_object = new WC_Product_Attribute();
//        $attribute_object->set_name($taxonomy);
//        $attribute_object->set_visible(true);
//        $attribute_object->set_variation(true);
//
//        $term_slugs = [];
//        $terms_data = [];
//        foreach ($items as $item) {
//            if (!isset($item['name']) || !isset($item['price'])) {
//                error_log("داده‌های نامعتبر برای آیتم: " . print_r($item, true));
//                continue;
//            }
//
//            $term_name = sanitize_text_field($item['name']);
//            $term_price = floatval($item['price']); // فقط قیمت ویژگی
//            $term_slug = get_custom_term_slug($term_name, $taxonomy);
//
//            $term = term_exists($term_name, $taxonomy);
//            if (!$term) {
//                $result = wp_insert_term($term_name, $taxonomy, ['slug' => $term_slug]);
//                if (is_wp_error($result)) {
//                    error_log("خطا در افزودن مقدار '$term_name' به '$taxonomy': " . $result->get_error_message());
//                    continue;
//                }
//                $term = get_term_by('name', $term_name, $taxonomy);
//                error_log("مقدار '$term_name' با slug '$term_slug' به '$taxonomy' اضافه شد.");
//            } else {
//                $term = get_term_by('id', $term['term_id'], $taxonomy);
//                error_log("مقدار '$term_name' با ID {$term->term_id} در '$taxonomy' وجود دارد.");
//            }
//
//            if ($term) {
//                $term_slugs[] = $term->slug;
//                $terms_data[] = [
//                    'slug'  => $term->slug,
//                    'name'  => $term_name,
//                    'price' => $term_price,
//                ];
//                wp_set_object_terms($post->ID, $term->term_id, $taxonomy, true);
//                error_log("مقدار '$term_name' با ID {$term->term_id} به محصول $post->ID لینک شد.");
//            }
//        }
//
//        $attribute_object->set_options($term_slugs);
//        $product_attributes[$taxonomy] = $attribute_object;
//        $all_terms[$taxonomy] = $terms_data;
//
//        if (!empty($term_slugs)) {
//            $default_attributes[$taxonomy] = $term_slugs[0];
//            error_log("ویژگی پیش‌فرض برای $taxonomy: " . $term_slugs[0]);
//        }
//    }
//
//    // ذخیره ویژگی‌ها
//    $product_attributes_data = [];
//    foreach ($product_attributes as $taxonomy => $attribute_object) {
//        $product_attributes_data[$taxonomy] = [
//            'name'         => $taxonomy,
//            'value'        => '',
//            'position'     => 0,
//            'is_visible'   => 1,
//            'is_variation' => 1,
//            'is_taxonomy'  => 1,
//        ];
//    }
//    update_post_meta($post->ID, '_product_attributes', $product_attributes_data);
//
//    // ایجاد تمام ترکیب‌های متغیرها
//    $combinations = [[]];
//    foreach ($all_terms as $taxonomy => $terms) {
//        $new_combinations = [];
//        foreach ($combinations as $combo) {
//            foreach ($terms as $term) {
//                $new_combo = $combo;
//                $new_combo[$taxonomy] = $term;
//                $new_combinations[] = $new_combo;
//            }
//        }
//        $combinations = $new_combinations;
//    }
//
//    // ایجاد متغیر برای هر ترکیب
//    $variation_prices = [];
//    foreach ($combinations as $combo) {
//        $variation = new WC_Product_Variation();
//        $variation->set_parent_id($post->ID);
//
//        $attributes = [];
//        $price = 0;
//        foreach ($combo as $taxonomy => $term) {
//            $attributes[$taxonomy] = $term['slug'];
//            $price = floatval($term['price']); // قیمت مستقیم از ویژگی
//        }
//
//        $variation->set_attributes($attributes);
//        $variation->set_regular_price(ceil($price * 1.12)); // اعمال ضریب
//        $variation->set_manage_stock(true);
//        $variation->set_stock_quantity(100);
//        $variation->set_backorders('no');
//        $variation->set_stock_status('instock');
//        $variation->set_sku('SKU-' . $post->ID . '-' . uniqid());
//        $variation_id = $variation->save();
//
//        $variation_prices[] = $price * 1.12; // برای تنظیم قیمت پایه
//
//        $variation_data = wc_get_product($variation_id);
//        $variation_attributes = $variation_data->get_attributes();
//        if (empty($variation_attributes)) {
//            error_log("خطا: ویژگی‌ها برای متغیر $variation_id ذخیره نشدند. ویژگی‌های تنظیم‌شده: " . print_r($attributes, true));
//        } else {
//            error_log("متغیر $variation_id ایجاد شد. ویژگی‌ها: " . print_r($variation_attributes, true));
//        }
//    }
//
//    // تنظیم قیمت پایه محصول
//    if (!empty($variation_prices)) {
//        $min_price = min($variation_prices);
//        update_post_meta($post->ID, '_regular_price', $min_price);
//        update_post_meta($post->ID, '_price', $min_price);
//        error_log("قیمت پایه محصول $id تنظیم شد: $min_price");
//    }
//
//    // ذخیره محصول
//    $product->set_attributes($product_attributes);
//    $product->set_default_attributes($default_attributes);
//    $product->set_manage_stock(false);
//    $product->set_stock_status('instock');
//    $product->save();
//
//    update_post_meta($post->ID, 'b_sync_varation', 1);
//    error_log("ویژگی‌ها و متغیرها با موفقیت به محصول اضافه شدند. ID: $id");
//    error_log("محصول نهایی: نوع: " . $product->get_type() . ", ویژگی‌ها: " . print_r($product->get_attributes(), true));
//}


// New Version With Price Not Zero

//function add_variations_CRON_New($id) {
//    $post = get_post($id);
//    if (!$post) {
//        error_log("پست با ID $id یافت نشد.");
//        return;
//    }
//
//    $b_price_update = get_post_meta($post->ID, 'b_price_update', true);
//    $product = wc_get_product($post->ID);
//    if (!$product) {
//        error_log("محصول با ID $id یافت نشد.");
//        return;
//    }
//
//    // بررسی موجودی
//    if (empty($b_price_update) || $b_price_update == '0') {
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(0);
//        $product->set_stock_status('outofstock');
//        $product->save();
//        error_log("محصول با ID $id ناموجود شد (b_price_update: $b_price_update).");
//        return;
//    }
//
//    // ادامه برای محصولات موجود
//    $variations_meta = get_post_meta($post->ID, 'b_variations', true);
//    $b_price = floatval($b_price_update ?: get_post_meta($post->ID, 'b_price', true));
//
//    if (empty($variations_meta)) {
//        error_log("متای b_variations خالی است. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        error_log("محصول $id به‌عنوان ساده با قیمت $b_price ذخیره شد.");
//        return;
//    }
//
//    $variations = maybe_unserialize($variations_meta);
//    if (!is_array($variations) || empty($variations)) {
//        error_log("متای b_variations نامعتبر است. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        error_log("محصول $id به‌عنوان ساده با قیمت $b_price ذخیره شد.");
//        return;
//    }
//
//    error_log("داده‌های b_variations: " . print_r($variations, true));
//
//    // پاکسازی کامل متغیرها و ویژگی‌ها
//    $existing_variations = $product->get_children();
//    foreach ($existing_variations as $variation_id) {
//        wp_delete_post($variation_id, true);
//        error_log("متغیر قدیمی $variation_id حذف شد.");
//    }
//    update_post_meta($post->ID, '_product_attributes', []);
//    $product->set_attributes([]);
//
//    // تنظیم محصول به نوع متغیر
//    wp_set_object_terms($post->ID, 'variable', 'product_type');
//    $product = wc_get_product($post->ID);
//    if (!$product || $product->get_type() !== 'variable') {
//        error_log("محصول به متغیر تغییر نکرد. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        return;
//    }
//
//    $product_attributes = [];
//    $default_attributes = [];
//    $all_terms = [];
//
//    // تابع تبدیل به لاتین
//    function transliterate_to_latin($text) {
//        $map = [
//            'گارانتی' => 'warranty',
//            'رنگ' => 'color',
//        ];
//        return isset($map[$text]) ? $map[$text] : sanitize_title($text);
//    }
//
//    // تابع برای دریافت slug سفارشی
//    function get_custom_term_slug($term_name, $taxonomy) {
//        $color_map = [
//            'سفید' => 'white',
//            'مشکی' => 'black',
//            'قرمز' => 'red',
//        ];
//        $warranty_map = [
//            'اصالت و سلامت فیزیکی بهمراه مهلت تست تحویل' => 'authenticity-test',
//            'اصالت وسلامت فیزیکی بهمراه یک هفته مهلت تست' => 'authenticity-one-week',
//        ];
//        if ($taxonomy === 'pa_color' && isset($color_map[$term_name])) {
//            return $color_map[$term_name];
//        }
//        if ($taxonomy === 'pa_warranty' && isset($warranty_map[$term_name])) {
//            return $warranty_map[$term_name];
//        }
//        return sanitize_title($term_name);
//    }
//
//    // جمع‌آوری تمام ویژگی‌ها و مقادیر
//    foreach ($variations as $attribute_name => $items) {
//        if ($attribute_name == 'warranty') {
//            $attribute_name = 'گارانتی';
//        }
//        if ($attribute_name == 'color') {
//            $attribute_name = 'رنگ';
//        }
//
//        $taxonomy = 'pa_' . transliterate_to_latin($attribute_name);
//        error_log("تاکسونومی در حال پردازش: $taxonomy");
//
//        if (!taxonomy_exists($taxonomy)) {
//            $result = wc_create_attribute([
//                'name'         => $attribute_name,
//                'slug'         => $taxonomy,
//                'type'         => 'select',
//                'order_by'     => 'menu_order',
//                'has_archives' => false,
//            ]);
//            if (is_wp_error($result)) {
//                error_log("خطا در ایجاد تاکسونومی $taxonomy: " . $result->get_error_message());
//                continue;
//            }
//            error_log("تاکسونومی $taxonomy ایجاد شد.");
//        }
//
//        $attribute_object = new WC_Product_Attribute();
//        $attribute_object->set_name($taxonomy);
//        $attribute_object->set_visible(true);
//        $attribute_object->set_variation(true);
//
//        $term_slugs = [];
//        $terms_data = [];
//        foreach ($items as $item) {
//            if (!isset($item['name']) || !isset($item['price'])) {
//                error_log("داده‌های نامعتبر برای آیتم: " . print_r($item, true));
//                continue;
//            }
//
//            $term_name = sanitize_text_field($item['name']);
//            $term_price = floatval($item['price']);
//            $term_slug = get_custom_term_slug($term_name, $taxonomy);
//
//            $term = term_exists($term_name, $taxonomy);
//            if (!$term) {
//                $result = wp_insert_term($term_name, $taxonomy, ['slug' => $term_slug]);
//                if (is_wp_error($result)) {
//                    error_log("خطا در افزودن مقدار '$term_name' به '$taxonomy': " . $result->get_error_message());
//                    continue;
//                }
//                $term = get_term_by('name', $term_name, $taxonomy);
//                error_log("مقدار '$term_name' با slug '$term_slug' به '$taxonomy' اضافه شد.");
//            } else {
//                $term = get_term_by('id', $term['term_id'], $taxonomy);
//                error_log("مقدار '$term_name' با ID {$term->term_id} در '$taxonomy' وجود دارد.");
//            }
//
//            if ($term) {
//                $term_slugs[] = $term->slug;
//                $terms_data[] = [
//                    'slug'  => $term->slug,
//                    'name'  => $term_name,
//                    'price' => $term_price,
//                ];
//                wp_set_object_terms($post->ID, $term->term_id, $taxonomy, true);
//                error_log("مقدار '$term_name' با ID {$term->term_id} به محصول $post->ID لینک شد.");
//            }
//        }
//
//        $attribute_object->set_options($term_slugs);
//        $product_attributes[$taxonomy] = $attribute_object;
//        $all_terms[$taxonomy] = $terms_data;
//
//        if (!empty($term_slugs)) {
//            $default_attributes[$taxonomy] = $term_slugs[0];
//            error_log("ویژگی پیش‌فرض برای $taxonomy: " . $term_slugs[0]);
//        }
//    }
//
//    // ذخیره ویژگی‌ها
//    $product_attributes_data = [];
//    foreach ($product_attributes as $taxonomy => $attribute_object) {
//        $product_attributes_data[$taxonomy] = [
//            'name'         => $taxonomy,
//            'value'        => '',
//            'position'     => 0,
//            'is_visible'   => 1,
//            'is_variation' => 1,
//            'is_taxonomy'  => 1,
//        ];
//    }
//    update_post_meta($post->ID, '_product_attributes', $product_attributes_data);
//
//    // ایجاد تمام ترکیب‌های متغیرها
//    $combinations = [[]];
//    foreach ($all_terms as $taxonomy => $terms) {
//        $new_combinations = [];
//        foreach ($combinations as $combo) {
//            foreach ($terms as $term) {
//                $new_combo = $combo;
//                $new_combo[$taxonomy] = $term;
//                $new_combinations[] = $new_combo;
//            }
//        }
//        $combinations = $new_combinations;
//    }
//
//    // ایجاد متغیر برای هر ترکیب
//    $variation_prices = [];
//    foreach ($combinations as $combo) {
//        $variation = new WC_Product_Variation();
//        $variation->set_parent_id($post->ID);
//
//        $attributes = [];
//        $price = $b_price; // شروع با قیمت پایه
//        foreach ($combo as $taxonomy => $term) {
//            $attributes[$taxonomy] = $term['slug'];
//            $price = max($price, floatval($term['price'])); // استفاده از بیشترین قیمت
//        }
//
//        if ($price <= 0) {
//            $price = $b_price; // اگر قیمت صفر بود، از b_price استفاده کن
//            error_log("قیمت متغیر برای محصول $id صفر بود، از b_price ($b_price) استفاده شد.");
//        }
//
//        $variation->set_attributes($attributes);
//        $variation->set_regular_price(ceil($price * 1.12));
//        $variation->set_manage_stock(true);
//        $variation->set_stock_quantity(100);
//        $variation->set_backorders('no');
//        $variation->set_stock_status('instock');
//        $variation->set_sku('SKU-' . $post->ID . '-' . uniqid());
//        $variation_id = $variation->save();
//
//        $variation_prices[] = $price * 1.12;
//
//        $variation_data = wc_get_product($variation_id);
//        $variation_attributes = $variation_data->get_attributes();
//        if (empty($variation_attributes)) {
//            error_log("خطا: ویژگی‌ها برای متغیر $variation_id ذخیره نشدند. ویژگی‌های تنظیم‌شده: " . print_r($attributes, true));
//        } else {
//            error_log("متغیر $variation_id ایجاد شد. ویژگی‌ها: " . print_r($variation_attributes, true));
//        }
//    }
//
//    // تنظیم قیمت پایه محصول
//    if (!empty($variation_prices)) {
//        $min_price = min($variation_prices);
//        update_post_meta($post->ID, '_regular_price', $min_price);
//        update_post_meta($post->ID, '_price', $min_price);
//        error_log("قیمت پایه محصول $id تنظیم شد: $min_price");
//    } else {
//        // اگر هیچ متغیری ایجاد نشد
//        $min_price = $b_price * 1.12;
//        update_post_meta($post->ID, '_regular_price', $min_price);
//        update_post_meta($post->ID, '_price', $min_price);
//        error_log("هیچ متغیری ایجاد نشد، قیمت پایه محصول $id با b_price تنظیم شد: $min_price");
//    }
//
//    // ذخیره محصول
//    $product->set_attributes($product_attributes);
//    $product->set_default_attributes($default_attributes);
//    $product->set_manage_stock(false);
//    $product->set_stock_status('instock');
//    $product->save();
//
//    update_post_meta($post->ID, 'b_sync_varation', 1);
//    error_log("ویژگی‌ها و متغیرها با موفقیت به محصول اضافه شدند. ID: $id");
//    error_log("محصول نهایی: نوع: " . $product->get_type() . ", ویژگی‌ها: " . print_r($product->get_attributes(), true));
//}


//function add_variations_CRON_New($id) {
//    $post = get_post($id);
//    if (!$post) {
//        error_log("پست با ID $id یافت نشد.");
//        return;
//    }
//
//    $b_price_update = get_post_meta($post->ID, 'b_price', true);
//    $b_price_update = $b_price_update ;
//    $product = wc_get_product($post->ID);
//    if (!$product) {
//        error_log("محصول با ID $id یافت نشد.");
//        return;
//    }
//
//    // بررسی موجودی
//    if (empty($b_price_update) || $b_price_update == '0') {
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(0);
//        $product->set_stock_status('outofstock');
//        $product->save();
//        error_log("محصول با ID $id ناموجود شد (b_price_update: $b_price_update).");
//        return;
//    }
//
//    // ادامه برای محصولات موجود
//    $variations_meta = get_post_meta($post->ID, 'b_variations', true);
//    if($variations_meta == ''){}else{
//        wp_set_object_terms($post->ID, 'variable', 'product_type');
//        update_post_meta($post->ID, '_product_type', 'variable');
//    }
//    $b_price = floatval($b_price_update ?: get_post_meta($post->ID, 'b_price', true));
//
//    if (empty($variations_meta)) {
//        error_log("متای b_variations خالی است. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        error_log("محصول $id به‌عنوان ساده با قیمت $b_price ذخیره شد.");
//        return;
//    }
//
//    $variations = maybe_unserialize($variations_meta);
//    if (!is_array($variations) || empty($variations)) {
//        error_log("متای b_variations نامعتبر است. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        error_log("محصول $id به‌عنوان ساده با قیمت $b_price ذخیره شد.");
//        return;
//    }
//
//    error_log("داده‌های b_variations: " . print_r($variations, true));
//    error_log("b_price_update: $b_price_update, b_price: $b_price");
//
//    // پاکسازی کامل متغیرها و ویژگی‌ها
//    $existing_variations = $product->get_children();
//    foreach ($existing_variations as $variation_id) {
//        wp_delete_post($variation_id, true);
//        error_log("متغیر قدیمی $variation_id حذف شد.");
//    }
//    update_post_meta($post->ID, '_product_attributes', []);
//    $product->set_attributes([]);
//
//    // تنظیم محصول به نوع متغیر
//    wp_set_object_terms($post->ID, 'variable', 'product_type');
//    $product = wc_get_product($post->ID);
//    if (!$product || $product->get_type() !== 'variable') {
//        error_log("محصول به متغیر تغییر نکرد. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        return;
//    }
//
//    $product_attributes = [];
//    $default_attributes = [];
//    $all_terms = [];
//
//    // تابع تبدیل به لاتین
//    function transliterate_to_latin($text) {
//        $map = [
//            'گارانتی' => 'warranty',
//            'رنگ' => 'color',
//        ];
//        return isset($map[$text]) ? $map[$text] : sanitize_title($text);
//    }
//
//    // تابع برای دریافت slug سفارشی
//    function get_custom_term_slug($term_name, $taxonomy) {
//        $color_map = [
//            'سفید' => 'white',
//            'مشکی' => 'black',
//            'قرمز' => 'red',
//        ];
//        $warranty_map = [
//            'اصالت و سلامت فیزیکی بهمراه مهلت تست تحویل' => 'authenticity-test',
//            'اصالت وسلامت فیزیکی بهمراه یک هفته مهلت تست' => 'authenticity-one-week',
//        ];
//        if ($taxonomy === 'pa_color' && isset($color_map[$term_name])) {
//            return $color_map[$term_name];
//        }
//        if ($taxonomy === 'pa_warranty' && isset($warranty_map[$term_name])) {
//            return $warranty_map[$term_name];
//        }
//        return sanitize_title($term_name);
//    }
//
//    // جمع‌آوری تمام ویژگی‌ها و مقادیر
//    foreach ($variations as $attribute_name => $items) {
//        if ($attribute_name == 'warranty') {
//            $attribute_name = 'گارانتی';
//        }
//        if ($attribute_name == 'color') {
//            $attribute_name = 'رنگ';
//        }
//
//        $taxonomy = 'pa_' . transliterate_to_latin($attribute_name);
//        error_log("تاکسونومی در حال پردازش: $taxonomy");
//
//        if (!taxonomy_exists($taxonomy)) {
//            $result = wc_create_attribute([
//                'name'         => $attribute_name,
//                'slug'         => $taxonomy,
//                'type'         => 'select',
//                'order_by'     => 'menu_order',
//                'has_archives' => false,
//            ]);
//            if (is_wp_error($result)) {
//                error_log("خطا در ایجاد تاکسونومی $taxonomy: " . $result->get_error_message());
//                continue;
//            }
//            error_log("تاکسونومی $taxonomy ایجاد شد.");
//        }
//
//        $attribute_object = new WC_Product_Attribute();
//        $attribute_object->set_name($taxonomy);
//        $attribute_object->set_visible(true);
//        $attribute_object->set_variation(true);
//
//        $term_slugs = [];
//        $terms_data = [];
//        foreach ($items as $item) {
//            if (!isset($item['name']) || !isset($item['price'])) {
//                error_log("داده‌های نامعتبر برای آیتم: " . print_r($item, true));
//                continue;
//            }
//
//            $term_name = sanitize_text_field($item['name']);
//            $term_price = floatval($item['price']);
//            $term_slug = get_custom_term_slug($term_name, $taxonomy);
//
//            $term = term_exists($term_name, $taxonomy);
//            if (!$term) {
//                $result = wp_insert_term($term_name, $taxonomy, ['slug' => $term_slug]);
//                if (is_wp_error($result)) {
//                    error_log("خطا در افزودن مقدار '$term_name' به '$taxonomy': " . $result->get_error_message());
//                    continue;
//                }
//                $term = get_term_by('name', $term_name, $taxonomy);
//                error_log("مقدار '$term_name' با slug '$term_slug' به '$taxonomy' اضافه شد.");
//            } else {
//                $term = get_term_by('id', $term['term_id'], $taxonomy);
//                error_log("مقدار '$term_name' با ID {$term->term_id} در '$taxonomy' وجود دارد.");
//            }
//
//            if ($term) {
//                $term_slugs[] = $term->slug;
//                $terms_data[] = [
//                    'slug'  => $term->slug,
//                    'name'  => $term_name,
//                    'price' => $term_price,
//                ];
//                wp_set_object_terms($post->ID, $term->term_id, $taxonomy, true);
//                error_log("مقدار '$term_name' با ID {$term->term_id} به محصول $post->ID لینک شد.");
//            }
//        }
//
//        $attribute_object->set_options($term_slugs);
//        $product_attributes[$taxonomy] = $attribute_object;
//        $all_terms[$taxonomy] = $terms_data;
//
//        if (!empty($term_slugs)) {
//            $default_attributes[$taxonomy] = $term_slugs[0];
//            error_log("ویژگی پیش‌فرض برای $taxonomy: " . $term_slugs[0]);
//        }
//    }
//
//    // ذخیره ویژگی‌ها
//    $product_attributes_data = [];
//    foreach ($product_attributes as $taxonomy => $attribute_object) {
//        $product_attributes_data[$taxonomy] = [
//            'name'         => $taxonomy,
//            'value'        => '',
//            'position'     => 0,
//            'is_visible'   => 1,
//            'is_variation' => 1,
//            'is_taxonomy'  => 1,
//        ];
//    }
//    update_post_meta($post->ID, '_product_attributes', $product_attributes_data);
//
//    // ایجاد تمام ترکیب‌های متغیرها
//    $combinations = [[]];
//    foreach ($all_terms as $taxonomy => $terms) {
//        $new_combinations = [];
//        foreach ($combinations as $combo) {
//            foreach ($terms as $term) {
//                $new_combo = $combo;
//                $new_combo[$taxonomy] = $term;
//                $new_combinations[] = $new_combo;
//            }
//        }
//        $combinations = $new_combinations;
//    }
//
//    // ایجاد متغیر برای هر ترکیب
//    $variation_prices = [];
//    foreach ($combinations as $combo) {
//        $variation = new WC_Product_Variation();
//        $variation->set_parent_id($post->ID);
//
//        $attributes = [];
//        $price = $b_price; // شروع با قیمت پایه
//        foreach ($combo as $taxonomy => $term) {
//            $attributes[$taxonomy] = $term['slug'];
//            $price += floatval($term['price']); // اضافه کردن قیمت ویژگی به پایه
//        }
//
//        if ($price <= 0) {
//            $price = $b_price;
//            error_log("قیمت متغیر برای محصول $id صفر بود، از b_price ($b_price) استفاده شد.");
//        }
//
//        $variation->set_attributes($attributes);
//        $variation->set_regular_price($price); // حذف ضریب 1.12
//        $variation->set_manage_stock(true);
//        $variation->set_stock_quantity(100);
//        $variation->set_backorders('no');
//        $variation->set_stock_status('instock');
//        $variation->set_sku('SKU-' . $post->ID . '-' . uniqid());
//        $variation_id = $variation->save();
//
//        $variation_prices[] = $price;
//
//        $variation_data = wc_get_product($variation_id);
//        $variation_attributes = $variation_data->get_attributes();
//        if (empty($variation_attributes)) {
//            error_log("خطا: ویژگی‌ها برای متغیر $variation_id ذخیره نشدند. ویژگی‌های تنظیم‌شده: " . print_r($attributes, true));
//        } else {
//            error_log("متغیر $variation_id ایجاد شد. ویژگی‌ها: " . print_r($variation_attributes, true));
//        }
//    }
//
//    // تنظیم قیمت پایه محصول
//    if (!empty($variation_prices)) {
//        $min_price = min($variation_prices);
//        update_post_meta($post->ID, '_regular_price', $min_price);
//        update_post_meta($post->ID, '_price', $min_price);
//        error_log("قیمت پایه محصول $id تنظیم شد: $min_price");
//    } else {
//        $min_price = $b_price;
//        update_post_meta($post->ID, '_regular_price', $min_price);
//        update_post_meta($post->ID, '_price', $min_price);
//        error_log("هیچ متغیری ایجاد نشد، قیمت پایه محصول $id با b_price تنظیم شد: $min_price");
//    }
//
//    // ذخیره محصول
//    $product->set_attributes($product_attributes);
//    $product->set_default_attributes($default_attributes);
//    $product->set_manage_stock(false);
//    $product->set_stock_status('instock');
//    $product->save();
//
//    update_post_meta($post->ID, 'b_sync_varation', 1);
//    error_log("ویژگی‌ها و متغیرها با موفقیت به محصول اضافه شدند. ID: $id");
//    error_log("محصول نهایی: نوع: " . $product->get_type() . ", ویژگی‌ها: " . print_r($product->get_attributes(), true));
//}

//function add_variations_CRON_New($id) {
//    $post = get_post($id);
//    if (!$post) {
//        error_log("پست با ID $id یافت نشد.");
//        return;
//    }
//
//    // دریافت قیمت و بررسی تغییر
//    $b_price_update = get_post_meta($post->ID, 'b_price_update', true);
//    $last_price = get_post_meta($post->ID, 'b_last_price_update', true);
//    $refreshed = get_post_meta($post->ID, 'b_variations_refreshed', true);
//
//    // فقط اگر قیمت تغییر کرده یا متغیرها هنوز ساخته نشدن اجرا بشه
//    if ($refreshed === '1' && $b_price_update === $last_price) {
//        error_log("محصول با ID $id قبلاً بازسازی شده و قیمت تغییر نکرده است.");
//    }
//
//    $product = wc_get_product($post->ID);
//    if (!$product) {
//        error_log("محصول با ID $id یافت نشد.");
//        return;
//    }
//
//    // بررسی موجودی
//    if (empty($b_price_update) || $b_price_update == '0') {
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(0);
//        $product->set_stock_status('outofstock');
//        $product->save();
//        error_log("محصول با ID $id ناموجود شد (b_price_update: $b_price_update).");
//        return;
//    }
//
//    // استفاده از b_price_update برای قیمت پایه
//    $b_price = floatval($b_price_update ?: get_post_meta($post->ID, 'b_price', true));
//
//    // دریافت متغیرها
//    $variations_meta = get_post_meta($post->ID, 'b_variations', true);
//    if (empty($variations_meta)) {
//        error_log("متای b_variations خالی است. ID: $id");
//        wp_set_object_terms($post->ID, 'simple', 'product_type');
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        update_post_meta($post->ID, 'b_variations_refreshed', '1');
//        update_post_meta($post->ID, 'b_last_price_update', $b_price_update);
//        error_log("محصول $id به‌عنوان ساده با قیمت $b_price ذخیره شد.");
//        return;
//    }
//
//    $variations = maybe_unserialize($variations_meta);
//    if (!is_array($variations) || empty($variations)) {
//        error_log("متای b_variations نامعتبر است. ID: $id");
//        wp_set_object_terms($post->ID, 'simple', 'product_type');
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        update_post_meta($post->ID, 'b_variations_refreshed', '1');
//        update_post_meta($post->ID, 'b_last_price_update', $b_price_update);
//        error_log("محصول $id به‌عنوان ساده با قیمت $b_price ذخیره شد.");
//        return;
//    }
//
//    error_log("داده‌های b_variations: " . print_r($variations, true));
//    error_log("b_price_update: $b_price_update, b_price: $b_price");
//
//    // پاکسازی کامل متغیرها و ویژگی‌ها
//    $existing_variations = $product->get_children();
//    foreach ($existing_variations as $variation_id) {
//        wp_delete_post($variation_id, true);
//        error_log("متغیر قدیمی $variation_id حذف شد.");
//    }
//    update_post_meta($post->ID, '_product_attributes', []);
//    $product->set_attributes([]);
//
//    // تنظیم محصول به نوع متغیر
//    wp_set_object_terms($post->ID, 'variable', 'product_type');
//    $product = wc_get_product($post->ID);
//    if (!$product || $product->get_type() !== 'variable') {
//        error_log("محصول به متغیر تغییر نکرد. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        update_post_meta($post->ID, 'b_variations_refreshed', '1');
//        update_post_meta($post->ID, 'b_last_price_update', $b_price_update);
//        return;
//    }
//
//    $product_attributes = [];
//    $default_attributes = [];
//    $all_terms = [];
//
//    // تابع تبدیل به لاتین
//    function transliterate_to_latin($text) {
//        $map = [
//            'گارانتی' => 'warranty',
//            'رنگ' => 'color',
//        ];
//        return isset($map[$text]) ? $map[$text] : sanitize_title($text);
//    }
//
//    // تابع برای دریافت slug سفارشی
//    function get_custom_term_slug($term_name, $taxonomy) {
//        $color_map = [
//            'سفید' => 'white',
//            'مشکی' => 'black',
//            'قرمز' => 'red',
//        ];
//        $warranty_map = [
//            'اصالت و سلامت فیزیکی بهمراه مهلت تست تحویل' => 'authenticity-test',
//            'اصالت وسلامت فیزیکی بهمراه یک هفته مهلت تست' => 'authenticity-one-week',
//        ];
//        if ($taxonomy === 'pa_color' && isset($color_map[$term_name])) {
//            return $color_map[$term_name];
//        }
//        if ($taxonomy === 'pa_warranty' && isset($warranty_map[$term_name])) {
//            return $warranty_map[$term_name];
//        }
//        return sanitize_title($term_name);
//    }
//
//    // جمع‌آوری تمام ویژگی‌ها و مقادیر
//    foreach ($variations as $attribute_name => $items) {
//        if ($attribute_name == 'warranty') {
//            $attribute_name = 'گارانتی';
//        }
//        if ($attribute_name == 'color') {
//            $attribute_name = 'رنگ';
//        }
//
//        $taxonomy = 'pa_' . transliterate_to_latin($attribute_name);
//        error_log("تاکسونومی در حال پردازش: $taxonomy");
//
//        if (!taxonomy_exists($taxonomy)) {
//            $result = wc_create_attribute([
//                'name'         => $attribute_name,
//                'slug'         => $taxonomy,
//                'type'         => 'select',
//                'order_by'     => 'menu_order',
//                'has_archives' => false,
//            ]);
//            if (is_wp_error($result)) {
//                error_log("خطا در ایجاد تاکسونومی $taxonomy: " . $result->get_error_message());
//                continue;
//            }
//            error_log("تاکسونومی $taxonomy ایجاد شد.");
//        }
//
//        $attribute_object = new WC_Product_Attribute();
//        $attribute_object->set_name($taxonomy);
//        $attribute_object->set_visible(true);
//        $attribute_object->set_variation(true);
//
//        $term_slugs = [];
//        $terms_data = [];
//        foreach ($items as $item) {
//            if (!isset($item['name']) || !isset($item['price'])) {
//                error_log("داده‌های نامعتبر برای آیتم: " . print_r($item, true));
//                continue;
//            }
//
//            $term_name = sanitize_text_field($item['name']);
//            $term_price = floatval($item['price']);
//            $term_slug = get_custom_term_slug($term_name, $taxonomy);
//
//            $term = term_exists($term_name, $taxonomy);
//            if (!$term) {
//                $result = wp_insert_term($term_name, $taxonomy, ['slug' => $term_slug]);
//                if (is_wp_error($result)) {
//                    error_log("خطا در افزودن مقدار '$term_name' به '$taxonomy': " . $result->get_error_message());
//                    continue;
//                }
//                $term = get_term_by('name', $term_name, $taxonomy);
//                error_log("مقدار '$term_name' با slug '$term_slug' به '$taxonomy' اضافه شد.");
//            } else {
//                $term = get_term_by('id', $term['term_id'], $taxonomy);
//                error_log("مقدار '$term_name' با ID {$term->term_id} در '$taxonomy' وجود دارد.");
//            }
//
//            if ($term) {
//                $term_slugs[] = $term->slug;
//                $terms_data[] = [
//                    'slug'  => $term->slug,
//                    'name'  => $term_name,
//                    'price' => $term_price,
//                ];
//                wp_set_object_terms($post->ID, $term->term_id, $taxonomy, true);
//                error_log("مقدار '$term_name' با ID {$term->term_id} به محصول $post->ID لینک شد.");
//            }
//        }
//
//        $attribute_object->set_options($term_slugs);
//        $product_attributes[$taxonomy] = $attribute_object;
//        $all_terms[$taxonomy] = $terms_data;
//
//        if (!empty($term_slugs)) {
//            $default_attributes[$taxonomy] = $term_slugs[0];
//            error_log("ویژگی پیش‌فرض برای $taxonomy: " . $term_slugs[0]);
//        }
//    }
//
//    // ذخیره ویژگی‌ها
//    $product_attributes_data = [];
//    foreach ($product_attributes as $taxonomy => $attribute_object) {
//        $product_attributes_data[$taxonomy] = [
//            'name'         => $taxonomy,
//            'value'        => '',
//            'position'     => 0,
//            'is_visible'   => 1,
//            'is_variation' => 1,
//            'is_taxonomy'  => 1,
//        ];
//    }
//    update_post_meta($post->ID, '_product_attributes', $product_attributes_data);
//
//    // ایجاد تمام ترکیب‌های متغیرها
//    $combinations = [[]];
//    foreach ($all_terms as $taxonomy => $terms) {
//        $new_combinations = [];
//        foreach ($combinations as $combo) {
//            foreach ($terms as $term) {
//                $new_combo = $combo;
//                $new_combo[$taxonomy] = $term;
//                $new_combinations[] = $new_combo;
//            }
//        }
//        $combinations = $new_combinations;
//    }
//
//    // ایجاد متغیر برای هر ترکیب
//    $variation_prices = [];
//    foreach ($combinations as $combo) {
//        $variation = new WC_Product_Variation();
//        $variation->set_parent_id($post->ID);
//
//        $attributes = [];
//        $price = $b_price; // شروع با b_price_update
//        foreach ($combo as $taxonomy => $term) {
//            $attributes[$taxonomy] = $term['slug'];
//            $price += floatval($term['price']); // اضافه کردن قیمت ویژگی
//        }
//
//        if ($price <= 0) {
//            $price = $b_price;
//            error_log("قیمت متغیر برای محصول $id صفر بود، از b_price ($b_price) استفاده شد.");
//        }
//
//        $variation->set_attributes($attributes);
//        $variation->set_regular_price($price);
//        $variation->set_manage_stock(true);
//        $variation->set_stock_quantity(100);
//        $variation->set_backorders('no');
//        $variation->set_stock_status('instock');
//        $variation->set_sku('SKU-' . $post->ID . '-' . uniqid());
//        $variation_id = $variation->save();
//
//        $variation_prices[] = $price;
//
//        $variation_data = wc_get_product($variation_id);
//        $variation_attributes = $variation_data->get_attributes();
//        if (empty($variation_attributes)) {
//            error_log("خطا: ویژگی‌ها برای متغیر $variation_id ذخیره نشدند. ویژگی‌های تنظیم‌شده: " . print_r($attributes, true));
//        } else {
//            error_log("متغیر $variation_id ایجاد شد. ویژگی‌ها: " . print_r($variation_attributes, true));
//        }
//    }
//
//    // تنظیم قیمت پایه محصول
//    if (!empty($variation_prices)) {
//        $min_price = min($variation_prices);
//        update_post_meta($post->ID, '_regular_price', $min_price);
//        update_post_meta($post->ID, '_price', $min_price);
//        error_log("قیمت پایه محصول $id تنظیم شد: $min_price");
//    } else {
//        $min_price = $b_price;
//        update_post_meta($post->ID, '_regular_price', $min_price);
//        update_post_meta($post->ID, '_price', $min_price);
//        error_log("هیچ متغیری ایجاد نشد، قیمت پایه محصول $id با b_price تنظیم شد: $min_price");
//    }
//
//    // ذخیره محصول
//    $product->set_attributes($product_attributes);
//    $product->set_default_attributes($default_attributes);
//    $product->set_manage_stock(false);
//    $product->set_stock_status('instock');
//    $product->save();
//
//    // علامت‌گذاری به‌عنوان بازسازی‌شده و ذخیره قیمت فعلی
//    update_post_meta($post->ID, 'b_sync_varation', 1);
//    update_post_meta($post->ID, 'b_variations_refreshed', '1');
//    update_post_meta($post->ID, 'b_last_price_update', $b_price_update);
//    error_log("ویژگی‌ها و متغیرها با موفقیت به محصول اضافه شدند. ID: $id");
//    error_log("محصول نهایی: نوع: " . $product->get_type() . ", ویژگی‌ها: " . print_r($product->get_attributes(), true));
//}


// فراخوانی تابع (مثلاً موقع بارگیری مدیریت یا یک اکشن خاص)
//function Update_Product_var() {
//    // کوئری برای پیدا کردن تمام محصولات با b_price = 0
//    $args = array(
//        'post_type'      => 'product',
//        'posts_per_page' => 50,
//        'post_status'    => 'publish',
//        'meta_query'     => array(
//            array(
//                'key'   => 'b_sync_varation',
//                'value' => '1',
//                "compare" => "!="
//            ),
//        ),
//    );
//
//    $query = new WP_Query($args);
//
//    // اگر محصولی یافت شد، همه را به حالت trash می‌بریم
//    if ($query->have_posts()) {
//        while ($query->have_posts()) {
//            $query->the_post();
//
//            add_variations_CRON(get_the_ID());
//        }
//    }
//
//    wp_reset_postdata();
//}
//// فراخوانی تابع (مثلاً موقع بارگیری مدیریت یا یک اکشن خاص)
//add_action('init', 'Update_Product_var');








// New Method

//function add_variations_CRON_New($id) {
//    $post = get_post($id);
//    if (!$post) {
//        error_log("پست با ID $id یافت نشد.");
//        return;
//    }
//
//    $b_price_update = get_post_meta($post->ID, 'b_price_update', true);
//    $product = wc_get_product($post->ID);
//    if (!$product) {
//        error_log("محصول با ID $id یافت نشد.");
//        return;
//    }
//
//    // بررسی موجودی
//    if (empty($b_price_update) || $b_price_update == '0') {
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(0);
//        $product->set_stock_status('outofstock');
//        $product->save();
//        error_log("محصول با ID $id ناموجود شد (b_price_update: $b_price_update).");
//        return;
//    }
//
//    // ادامه برای محصولات موجود
//    $variations_meta = get_post_meta($post->ID, 'b_variations', true);
//    $b_price = floatval($b_price_update ?: get_post_meta($post->ID, 'b_price', true));
//
//    // اعتبارسنجی b_price
//    if ($b_price <= 0) {
//        error_log("خطا: قیمت پایه (b_price) برای محصول $id نامعتبر است ($b_price).");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(0);
//        $product->set_stock_status('outofstock');
//        $product->save();
//        return;
//    }
//
//    if (empty($variations_meta)) {
//        error_log("متای b_variations خالی است. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        error_log("محصول $id به‌عنوان ساده با قیمت $b_price ذخیره شد.");
//        return;
//    }
//
//    $variations = maybe_unserialize($variations_meta);
//    if (!is_array($variations) || empty($variations)) {
//        error_log("متای b_variations نامعتبر است. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        error_log("محصول $id به‌عنوان ساده با قیمت $b_price ذخیره شد.");
//        return;
//    }
//
//    error_log("داده‌های b_variations: " . print_r($variations, true));
//
//    // پاکسازی کامل متغیرها و ویژگی‌ها
//    $existing_variations = $product->get_children();
//    foreach ($existing_variations as $variation_id) {
//        wp_delete_post($variation_id, true);
//        error_log("متغیر قدیمی $variation_id حذف شد.");
//    }
//    update_post_meta($post->ID, '_product_attributes', []);
//    $product->set_attributes([]);
//
//    // تنظیم محصول به نوع متغیر
//    wp_set_object_terms($post->ID, 'variable', 'product_type');
//    $product = wc_get_product($post->ID);
//    if (!$product || $product->get_type() !== 'variable') {
//        error_log("محصول به متغیر تغییر نکرد. ID: $id");
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        return;
//    }
//
//    $product_attributes = [];
//    $default_attributes = [];
//    $all_terms = [];
//
//    // تابع تبدیل به لاتین
//    function transliterate_to_latin($text) {
//        $map = [
//            'گارانتی' => 'warranty',
//            'رنگ' => 'color',
//        ];
//        return isset($map[$text]) ? $map[$text] : sanitize_title($text);
//    }
//
//    // تابع برای دریافت slug سفارشی
//    function get_custom_term_slug($term_name, $taxonomy) {
//        $color_map = [
//            'سفید' => 'white',
//            'مشکی' => 'black',
//            'قرمز' => 'red',
//        ];
//        $warranty_map = [
//            'اصالت و سلامت فیزیکی بهمراه مهلت تست تحویل' => 'authenticity-test',
//            'اصالت وسلامت فیزیکی بهمراه یک هفته مهلت تست' => 'authenticity-one-week',
//            'یکسال گارانتی توسن' => 'one-year-tosan-warranty',
//        ];
//        if ($taxonomy === 'pa_color' && isset($color_map[$term_name])) {
//            return $color_map[$term_name];
//        }
//        if ($taxonomy === 'pa_warranty' && isset($warranty_map[$term_name])) {
//            return $warranty_map[$term_name];
//        }
//        return sanitize_title($term_name);
//    }
//
//    // جمع‌آوری تمام ویژگی‌ها و مقادیر
//    foreach ($variations as $attribute_name => $items) {
//        if ($attribute_name == 'warranty') {
//            $attribute_name = 'گارانتی';
//        }
//        if ($attribute_name == 'color') {
//            $attribute_name = 'رنگ';
//        }
//
//        $taxonomy = 'pa_' . transliterate_to_latin($attribute_name);
//        error_log("تاکسونومی در حال پردازش: $taxonomy");
//
//        if (!taxonomy_exists($taxonomy)) {
//            $result = wc_create_attribute([
//                'name'         => $attribute_name,
//                'slug'         => $taxonomy,
//                'type'         => 'select',
//                'order_by'     => 'menu_order',
//                'has_archives' => false,
//            ]);
//            if (is_wp_error($result)) {
//                error_log("خطا در ایجاد تاکسونومی $taxonomy: " . $result->get_error_message());
//                continue;
//            }
//            error_log("تاکسونومی $taxonomy ایجاد شد.");
//        }
//
//        $attribute_object = new WC_Product_Attribute();
//        $attribute_object->set_name($taxonomy);
//        $attribute_object->set_visible(true);
//        $attribute_object->set_variation(true);
//
//        $term_slugs = [];
//        $terms_data = [];
//        foreach ($items as $item) {
//            if (!isset($item['name']) || !isset($item['price'])) {
//                error_log("داده‌های نامعتبر برای آیتم: " . print_r($item, true));
//                continue;
//            }
//
//            $term_name = sanitize_text_field($item['name']);
//            $term_price = floatval($item['price']);
//
//            // مدیریت قیمت صفر
//            if ($term_price <= 0) {
//                error_log("هشدار: قیمت آیتم '$term_name' در تاکسونومی $taxonomy صفر است، از b_price ($b_price) استفاده می‌شود.");
//                $term_price = $b_price;
//            }
//
//            $term_slug = get_custom_term_slug($term_name, $taxonomy);
//            error_log("ایجاد/بررسی مقدار '$term_name' با slug '$term_slug' برای $taxonomy");
//
//            $term = term_exists($term_name, $taxonomy);
//            if (!$term) {
//                $result = wp_insert_term($term_name, $taxonomy, ['slug' => $term_slug]);
//                if (is_wp_error($result)) {
//                    error_log("خطا در افزودن مقدار '$term_name' به '$taxonomy': " . $result->get_error_message());
//                    continue;
//                }
//                $term = get_term_by('name', $term_name, $taxonomy);
//                error_log("مقدار '$term_name' با slug '$term_slug' به '$taxonomy' اضافه شد.");
//            } else {
//                $term = get_term_by('id', $term['term_id'], $taxonomy);
//                error_log("مقدار '$term_name' با ID {$term->term_id} در '$taxonomy' وجود دارد.");
//            }
//
//            if ($term) {
//                $term_slugs[] = $term->slug;
//                $terms_data[] = [
//                    'slug'  => $term->slug,
//                    'name'  => $term_name,
//                    'price' => $term_price,
//                ];
//                wp_set_object_terms($post->ID, $term->term_id, $taxonomy, true);
//                error_log("مقدار '$term_name' با ID {$term->term_id} به محصول $post->ID لینک شد.");
//            }
//        }
//
//        // بررسی وجود مقادیر
//        if (empty($term_slugs)) {
//            error_log("خطا: هیچ مقداری برای تاکسونومی $taxonomy ایجاد نشد، محصول به حالت ساده تنظیم می‌شود.");
//            wp_set_object_terms($post->ID, 'simple', 'product_type');
//            $product = wc_get_product($post->ID);
//            $product->set_manage_stock(true);
//            $product->set_stock_quantity(100);
//            $product->set_stock_status('instock');
//            $product->set_regular_price($b_price);
//            $product->set_price($b_price);
//            $product->save();
//            error_log("محصول $id به‌عنوان ساده با قیمت $b_price ذخیره شد.");
//            return;
//        }
//
//        $attribute_object->set_options($term_slugs);
//        $product_attributes[$taxonomy] = $attribute_object;
//        $all_terms[$taxonomy] = $terms_data;
//
//        $default_attributes[$taxonomy] = $term_slugs[0];
//        error_log("ویژگی پیش‌فرض برای $taxonomy: " . $term_slugs[0]);
//    }
//
//    // ذخیره ویژگی‌ها
//    $product_attributes_data = [];
//    foreach ($product_attributes as $taxonomy => $attribute_object) {
//        $product_attributes_data[$taxonomy] = [
//            'name'         => $taxonomy,
//            'value'        => '',
//            'position'     => 0,
//            'is_visible'   => 1,
//            'is_variation' => 1,
//            'is_taxonomy'  => 1,
//        ];
//    }
//    update_post_meta($post->ID, '_product_attributes', $product_attributes_data);
//    error_log("ویژگی‌های محصول ذخیره شدند: " . print_r($product_attributes_data, true));
//
//    // ایجاد تمام ترکیب‌های متغیرها
//    $combinations = [[]];
//    foreach ($all_terms as $taxonomy => $terms) {
//        $new_combinations = [];
//        foreach ($combinations as $combo) {
//            foreach ($terms as $term) {
//                $new_combo = $combo;
//                $new_combo[$taxonomy] = $term;
//                $new_combinations[] = $new_combo;
//            }
//        }
//        $combinations = $new_combinations;
//    }
//
//    if (empty($combinations)) {
//        error_log("خطا: هیچ ترکیبی برای متغیرها ایجاد نشد. ID: $id");
//        wp_set_object_terms($post->ID, 'simple', 'product_type');
//        $product = wc_get_product($post->ID);
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        error_log("محصول $id به‌عنوان ساده با قیمت $b_price ذخیره شد.");
//        return;
//    }
//
//    // ایجاد متغیر برای هر ترکیب
//    $variation_prices = [];
//    foreach ($combinations as $combo) {
//        $variation = new WC_Product_Variation();
//        $variation->set_parent_id($post->ID);
//
//        $attributes = [];
//        $price = $b_price; // اصلاح: خطای نگارشی برطرف شد
//        foreach ($combo as $taxonomy => $term) {
//            $attributes[$taxonomy] = $term['slug'];
//            $price = max($price, floatval($term['price']));
//        }
//
//        if ($price <= 0 || !is_numeric($price)) {
//            error_log("خطا: قیمت متغیر برای محصول $id نامعتبر است ($price).");
//            continue;
//        }
//
//        $variation->set_attributes($attributes);
//        $variation_price = ceil($price * 1.12);
//        $variation->set_regular_price($variation_price);
//        $variation->set_sale_price('');
//        $variation->set_manage_stock(true);
//        $variation->set_stock_quantity(100);
//        $variation->set_stock_status('instock');
//        $variation->set_backorders('no');
//        $variation->set_sku('SKU-' . $post->ID . '-' . uniqid());
//
//        $variation_id = $variation->save();
//        if (!$variation_id) {
//            error_log("خطا: متغیر برای محصول $id ذخیره نشد.");
//            continue;
//        }
//
//        $variation_prices[] = $variation_price;
//
//        $variation_data = wc_get_product($variation_id);
//        $variation_attributes = $variation_data->get_attributes();
//        if (empty($variation_attributes)) {
//            error_log("خطا: ویژگی‌ها برای متغیر $variation_id ذخیره نشدند. ویژگی‌های تنظیم‌شده: " . print_r($attributes, true));
//        } else {
//            error_log("متغیر $variation_id ایجاد شد. ویژگی‌ها: " . print_r($variation_attributes, true));
//            error_log("قیمت متغیر $variation_id: $variation_price");
//            error_log("وضعیت موجودی متغیر $variation_id: " . $variation_data->get_stock_status());
//            error_log("مقدار is_purchasable برای متغیر $variation_id: " . ($variation_data->is_purchasable() ? 'true' : 'false'));
//        }
//    }
//
//    if (empty($variation_prices)) {
//        error_log("خطا: هیچ متغیری برای محصول $id ایجاد نشد.");
//        wp_set_object_terms($post->ID, 'simple', 'product_type');
//        $product = wc_get_product($post->ID);
//        $product->set_manage_stock(true);
//        $product->set_stock_quantity(100);
//        $product->set_stock_status('instock');
//        $product->set_regular_price($b_price);
//        $product->set_price($b_price);
//        $product->save();
//        error_log("محصول $id به‌عنوان ساده با قیمت $b_price ذخیره شد.");
//        return;
//    }
//
//    // تنظیم قیمت پایه محصول
//    $min_price = min($variation_prices);
//    $max_price = max($variation_prices);
//    update_post_meta($post->ID, '_regular_price', $min_price);
//    update_post_meta($post->ID, '_price', $min_price);
//    update_post_meta($post->ID, '_min_variation_price', $min_price);
//    update_post_meta($post->ID, '_max_variation_price', $max_price);
//    error_log("قیمت پایه محصول $id تنظیم شد: $min_price (حداکثر: $max_price)");
//
//    // ذخیره محصول
//    $product->set_attributes($product_attributes);
//    $product->set_default_attributes($default_attributes);
//    $product->set_manage_stock(false);
//    $product->set_stock_status('instock');
//    $product->save();
//
//    update_post_meta($post->ID, 'b_sync_varation', 1);
//    error_log("ویژگی‌ها و متغیرها با موفقیت به محصول اضافه شدند. ID: $id");
//    error_log("محصول نهایی: نوع: " . $product->get_type() . ", ویژگی‌ها: " . print_r($product->get_attributes(), true));
//    error_log("ویژگی‌های پیش‌فرض: " . print_r($default_attributes, true));
//}




function add_variations_CRON_New($id) {
    $post = get_post($id);

    if (!$post) return error_log("پست با ID $id یافت نشد.");

    $b_price_update = ceil(get_post_meta($post->ID, 'b_price_update', true));
    $b_price = floatval($b_price_update ?: get_post_meta($post->ID, 'b_price', true));
    $b_price = ceil($b_price / 1000) * 1000;
    $product = wc_get_product($post->ID);
    if (!$product) return error_log("محصول با ID $id یافت نشد.");

    // اگر قیمت نداشت یا صفر بود، محصول را ناموجود کن
    if ($b_price <= 0) {
        $product->set_manage_stock(true);
        $product->set_stock_quantity(0);
        $product->set_stock_status('outofstock');
        $product->save();
        return error_log("قیمت معتبر نیست. محصول $id ناموجود شد.");
    }

    $variations_meta = get_post_meta($post->ID, 'b_variations', true);
    $variations = maybe_unserialize($variations_meta);

    // اگر متغیر نبود، محصول ساده ثبت شود
    if (empty($variations) || !is_array($variations)) {
        $product->set_manage_stock(true);
        $product->set_stock_quantity(100);
        $product->set_stock_status('instock');
        $product->set_regular_price($b_price);
        $product->set_price($b_price);
        $product->save();
        return error_log("محصول $id ساده ذخیره شد. قیمت: $b_price");
    }

    // پاک‌سازی متغیرهای قبلی
    foreach ($product->get_children() as $variation_id) {
        wp_delete_post($variation_id, true);
    }
    update_post_meta($post->ID, '_product_attributes', []);
    $product->set_attributes([]);

    // تنظیم نوع محصول به متغیر
    wp_set_object_terms($post->ID, 'variable', 'product_type');
    $product = wc_get_product($post->ID);

    $product_attributes = [];
    $default_attributes = [];
    $all_terms = [];

    foreach ($variations as $attribute_name => $items) {
        $taxonomy = 'pa_' . sanitize_title($attribute_name);
        if (!taxonomy_exists($taxonomy)) {
            $result = wc_create_attribute([
                'name' => $attribute_name,
                'slug' => $taxonomy,
                'type' => 'select',
                'order_by' => 'menu_order',
                'has_archives' => false,
            ]);
            if (is_wp_error($result)) continue;
        }

        $attribute = new WC_Product_Attribute();
        $attribute->set_name($taxonomy);
        $attribute->set_visible(true);
        $attribute->set_variation(true);

        $term_slugs = [];
        $terms_data = [];

        foreach ($items as $item) {
            if (empty($item['name'])) continue;

            $term_name = sanitize_text_field($item['name']);
            $term_slug = sanitize_title($term_name);
//            $term_price = !empty($item['price']) ? floatval($item['price']) : $b_price;
            $term_price = $b_price + ($item['price'] * 1.12);

            if ($term_price <= 0) $term_price = $b_price;

            if (!term_exists($term_name, $taxonomy)) {
                wp_insert_term($term_name, $taxonomy, ['slug' => $term_slug]);
            }

            $term = get_term_by('slug', $term_slug, $taxonomy);
            if (!$term) continue;

            wp_set_object_terms($post->ID, $term->term_id, $taxonomy, true);

            $term_slugs[] = $term->slug;
            $terms_data[] = [
                'slug'  => $term->slug,
                'name'  => $term_name,
                'price' => $term_price,
            ];
        }

        if (!empty($term_slugs)) {
            $attribute->set_options($term_slugs);
            $product_attributes[$taxonomy] = $attribute;
            $all_terms[$taxonomy] = $terms_data;
            $default_attributes[$taxonomy] = $term_slugs[0];
        }
    }

    // ست کردن ویژگی‌ها در محصول
    $product->set_attributes($product_attributes);
    $product->set_default_attributes($default_attributes);

    // ذخیره متای ویژگی‌ها
    $product_attributes_data = [];
    foreach ($product_attributes as $taxonomy => $attribute_object) {
        $product_attributes_data[$taxonomy] = $attribute_object->get_data();
    }
    update_post_meta($post->ID, '_product_attributes', $product_attributes_data);

    // ایجاد ترکیب‌های متغیرها
    $combinations = [[]];
    foreach ($all_terms as $taxonomy => $terms) {
        $new_combinations = [];
        foreach ($combinations as $combo) {
            foreach ($terms as $term) {
                $new_combo = $combo;
                $new_combo[$taxonomy] = $term;
                $new_combinations[] = $new_combo;
            }
        }
        $combinations = $new_combinations;
    }

    $variation_prices = [];
    foreach ($combinations as $combo) {
        $variation = new WC_Product_Variation();
        $variation->set_parent_id($post->ID);

        $attributes = [];
        $price = $b_price;
        foreach ($combo as $taxonomy => $term) {
            $attributes[$taxonomy] = $term['slug'];
            $price = max($price, floatval($term['price']));
        }

        $variation->set_attributes($attributes);
        $variation_price = $price ;
        $variation->set_regular_price($variation_price);
        $variation->set_manage_stock(true);
        $variation->set_stock_quantity(100);
        $variation->set_stock_status('instock');
        $variation->set_sku('SKU-' . $post->ID . '-' . uniqid());
        $variation_id = $variation->save();

        if ($variation_id) {
            $variation_prices[] = $variation_price;
        }
    }

    // تنظیم قیمت محصول مادر
    if (!empty($variation_prices)) {
        $min_price = min($variation_prices);
        $max_price = max($variation_prices);
        update_post_meta($post->ID, '_regular_price', $min_price);
        update_post_meta($post->ID, '_price', $min_price);
        update_post_meta($post->ID, '_min_variation_price', $min_price);
        update_post_meta($post->ID, '_max_variation_price', $max_price);
    }

    // ذخیره نهایی محصول
    $product->set_manage_stock(false);
    $product->set_stock_status('instock');
    $product->save();

    // حذف کش برای رفع is_purchasable
    wc_delete_product_transients($post->ID);

    update_post_meta($post->ID, 'b_sync_varation', 1);
    error_log("محصول $id با متغیرها با موفقیت ذخیره شد.");
}

// Ediiit 1
function hdm_refresh_variations_on_product_view() {
    if (is_product()) {
        global $post;
        $product_id = $post->ID;
        $crawler_setting = get_field('crawler_setting',$product_id);
        if($crawler_setting == "deactive"){}else{
        // فقط برای محصولات متغیر اجرا شود
        if ('product' === get_post_type($product_id) && 'variable' === get_post_meta($product_id, '_product_type', true)) {

            // پاک کردن تمام متغیرها (Variations)
            $children = get_children(array(
                'post_parent' => $product_id,
                'post_type'   => 'product_variation',
                'numberposts' => -1,
                'post_status' => 'any',
            ));
            foreach ($children as $child) {
                wp_delete_post($child->ID, true);
            }

            // پاک کردن ویژگی‌ها (Attributes) از متای محصول
            delete_post_meta($product_id, '_product_attributes');

            // اگر نیاز باشد ترم‌های ویژگی هم حذف شوند، باید در اینجا اضافه شود، فعلاً حذف نمی‌کنیم

            // اجرای تابع ساخت مجدد ویژگی‌ها و متغیرها
            if (function_exists('add_variations_CRON_New')) {
                add_variations_CRON_New($product_id);
            }
        }
        }
    }
}

add_action('template_redirect', 'hdm_refresh_variations_on_product_view');


function hdm_refresh_variations_cron($product_id) {
    if ('product' === get_post_type($product_id) && 'variable' === get_post_meta($product_id, '_product_type', true)) {
        // پاک کردن تمام متغیرها (Variations)
        $children = get_children(array(
            'post_parent' => $product_id,
            'post_type'   => 'product_variation',
            'numberposts' => -1,
            'post_status' => 'any',
        ));
        foreach ($children as $child) {
            wp_delete_post($child->ID, true);
        }

        // پاک کردن ویژگی‌ها (Attributes)
        delete_post_meta($product_id, '_product_attributes');

        // اجرای تابع ساخت مجدد ویژگی‌ها و متغیرها
        if (function_exists('add_variations_CRON_New')) {
            add_variations_CRON_New($product_id);
        }
    }
}

add_filter('cron_schedules', function ($schedules) {
    $schedules['every_5_minutes_new'] = array(
        'interval' => 120 * MINUTE_IN_SECONDS,
        'display'  => __('every_5_minutes_new')
    );
    return $schedules;
});

function hdm_run_variation_refresh_for_all_products() {
    $args = [
        'post_type'      => 'product',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        "meta_query" => array(
            "relation" => "AND",
            array(
                "key" => "b_price_update",
                "value" => "0",
                "compare" => "!="
            ),
            array(
                "key" => "b_variations",
                "compare" => "EXISTS"
            )
        )
    ];

    $products = get_posts($args);
    foreach ($products as $product) {
        hdm_refresh_variations_cron($product->ID);
        error_log("--------------********* ".$product->ID);
    }
}



add_action('init', function () {
    if (!wp_next_scheduled('hdm_refresh_variations_cron_event')) {
        wp_schedule_event(time(), 'every_5_minutes_new', 'hdm_refresh_variations_cron_event');
    }
});


add_action('hdm_refresh_variations_cron_event', 'hdm_run_variation_refresh_for_all_products');






add_action('admin_init', 'my_update_images');
function my_update_images() {
    if(isset($_GET['UpdateImage'])){

        $args = array(
            'post_type'      => 'product',
            'posts_per_page' => 2,
            'post_status'    => 'publish',
            'meta_query'     => array(
                array(
                    'key'   => '_product_image_gallery',
                    "compare" => "NOT EXISTS"
                ),
            ),
        );

        $query = get_posts($args);

        // اگر محصولی یافت شد، همه را به حالت trash می‌بریم
        foreach($query as $item) {

            $_product_image_gallery = get_post_meta($item->ID, "_product_image_gallery", true);
            if ($_product_image_gallery == '') {
                $product_id = $item->ID;
                $gallery_urls = array(strtok(get_post_meta($item->ID, "b_product_thumbnail", true), "?"));

                $attachment_ids = [];

                foreach ($gallery_urls as $url) {
                    $attachment_id = attachment_url_to_postid($url);

                    if (!$attachment_id) {
                        $attachment_id = wp_insert_attachment([
                            'guid' => $url,
                            'post_mime_type' => 'image/jpeg',
                            'post_title' => basename($url),
                            'post_content' => '',
                            'post_status' => 'inherit',
                        ], $url);

                        if (!is_wp_error($attachment_id)) {

                            require_once(ABSPATH . 'wp-admin/includes/image.php');
                            wp_update_attachment_metadata($attachment_id, wp_generate_attachment_metadata($attachment_id, $url));

                        }
                    }

                    $attachment_ids[] = $attachment_id;
                }
                update_post_meta($item->ID, '_product_image_gallery', implode(',', $attachment_ids));
                echo $product_id . '</br>';
            }
        }
        echo '
    
                    <script type="text/javascript" src="https://code.jquery.com/jquery-3.7.1.js"></script>
                    <script>
                        jQuery(window).on("load",function (){
                            window.location.reload();
                        })
                    </script>
                
                ';
        die();

    }
}



//    Delete All Variation And Add New Variation

//add_action('template_redirect', 'hdm_refresh_variations_on_product_view');

//function hdm_refresh_variations_on_product_view() {
//    if (is_product()) {
//        global $post;
//
//        $product_id = $post->ID;
//
//        // بررسی کن که آیا این محصول متغیره
//        if ('product' === get_post_type($product_id) && 'variable' === get_post_meta($product_id, '_product_type', true)) {
//
//            // فقط یکبار در هر بار لود اجرا شود
//
//            // پاک کردن تمام متغیرهای محصول
//            $children = get_children(array(
//                'post_parent' => $product_id,
//                'post_type'   => 'product_variation',
//                'numberposts' => -1,
//                'post_status' => 'any',
//            ));
//
//            foreach ($children as $child) {
//                wp_delete_post($child->ID, true);
//            }
//
//            // اجرای تابع ساخت متغیر جدید
//            if (function_exists('add_variations_CRON_New')) {
//
//                add_variations_CRON_New($product_id);
//            }
//
//
//        }
//    }
//}

// Old Version Delete




function berozkala_email_log_and_clear() {
    $upload_dir = wp_upload_dir();
    $log_file = trailingslashit($upload_dir['basedir']) . 'crawler_log.txt';

    if (!file_exists($log_file)) return;

    $log_lines = file($log_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    if (!$log_lines) return;

    // ساخت جدول HTML
    $html = '<h2>گزارش لاگ کرالر</h2>';
    $html .= '<table border="1" cellpadding="6" cellspacing="0" style="border-collapse: collapse; width: 100%; font-family: sans-serif; font-size: 14px;">';
    $html .= '<thead style="background-color: #f5f5f5;"><tr><th>⏰ زمان</th><th>📝 پیام</th></tr></thead><tbody>';

    foreach ($log_lines as $line) {
        if (preg_match('/^\[(.*?)\] (.*)$/u', $line, $matches)) {
            $time = esc_html($matches[1]);
            $message = esc_html($matches[2]);
            $html .= "<tr><td>{$time}</td><td>{$message}</td></tr>";
        }
    }

    $html .= '</tbody></table>';

    // ارسال ایمیل
    $to = 'info@kharidstore.com'; // ایمیل خودت رو جایگزین کن
    $subject = '📋 گزارش لاگ کرالر - ' . date('Y-m-d H:i');
    $headers = array('Content-Type: text/html; charset=UTF-8');

    wp_mail($to, $subject, $html, $headers);

    // حذف فایل لاگ
    unlink($log_file);
}