jQuery(document).ready(function ($) {


    if ( survey_data.dynamicpoints == 'yes') {
        $('.fb_wrapper.np_points_wrppaer textarea.negative_points').hide();
        $('.suggestion_wrapper span').on('click', function() {
            $('.suggestion_yes').on('click', function(){
                $('.fb_wrapper.np_points_wrppaer textarea.negative_points').hide();
                $('.fb_wrapper.np_points_wrppaer textarea.positive_points').show();
            });
            $('.suggestion_no').on('click', function(){
                $('.fb_wrapper.np_points_wrppaer textarea.negative_points').show();
                $('.fb_wrapper.np_points_wrppaer textarea.positive_points').hide();
            });
            $(this).toggleClass('sugg_active');
            $(this).siblings('span').toggleClass('sugg_active');
        });
    }

    $('.suggestion_yes').on('click', function(){
        $(this).addClass('sugg_active');
        $('.suggestion_no').removeClass('sugg_active');
    });

    $('.suggestion_no').on('click', function(){
        $(this).addClass('sugg_active');
        $('.suggestion_yes').removeClass('sugg_active');
    });

    // static emoji rating
    $('div.survey .rating #rating-5').trigger('click');
    $('div.survey .rating input').on('click', function(){
        $('div.survey .rating input').removeClass('active');
        $(this).addClass('active');
    });

    // static star rating
    $('.star__item').on('click', function() {
        $('.star__item').removeClass('rating_active');
        $(this).addClass('rating_active');
    });
    $('.star__item[data-rating="5"]').trigger('click');


  // textarea

  var $txtarea_comment = $(".fcomment_body");
  $txtarea_comment.on('input', function(e){
        var scroll_height = $txtarea_comment.get(0).scrollHeight;
        $txtarea_comment.css('height', scroll_height + 'px');
  });


  var $txtarea_positive = $(".positive_points");
  $txtarea_positive.on('keyup', function(e){
    var scroll_height = $txtarea_positive.get(0).scrollHeight;
    $txtarea_positive.css('height', scroll_height + 'px');
  });


  var $txtarea_negative = $(".negative_points");
  $txtarea_negative.on('keyup', function(e){
    var scroll_height = $txtarea_negative.get(0).scrollHeight;
    $txtarea_negative.css('height', scroll_height + 'px');
  });
  

  $('.fb_wrapper.fsubmit .buttons .btn').on( 'click' , function(e){
    e.preventDefault();
    var $this = $(this);
    var $rating ='';

    // animated emoji
    if ($('ul.survey').length > 0) {
        $rating = $this.parent().parent('.fb_wrapper').siblings('.fb_wrapper.survey_ltr').find('ul.survey li.active').attr('data-rating');
    }

    //static emoji
    if ($('div.survey').length > 0) {
        $rating = $this.parent().parent('.fb_wrapper').siblings('.fb_wrapper.survey_ltr').find('label.rating_active_current').attr('data-rating');
        if ($rating == null) {
            $rating = 5;
        }
    }
    
    // static star rating
    if ($('.star__item').length > 0) {
        $rating = $this.parent().parent('.fb_wrapper').siblings('.fb_wrapper.survey_ltr').find('.star__item.rating_active_current').attr('data-rating');
    }

    // animated star rating
    if ($('nav.rating').length > 0) {
        $rating = $this.parent().parent('.fb_wrapper').siblings('.fb_wrapper.survey_ltr').find('nav.rating li.current').attr('data-rating');
    }


    var $user_id    = $this.parent().parent().siblings('.fb_wrapper.fextradata').find('.fuserid').val();
    var $product_id = $this.parent().parent().siblings('.fb_wrapper.fextradata').find('.fproductid').val();
    var $order_id   = $this.parent().parent().siblings('.fb_wrapper.fextradata').find('.forderid').val();

    var $positive   = '';
    var $negative   = '';
    
    if (survey_data.disablepnpoints == 'no') {
        var $positive   = $this.parent().parent().siblings('.fb_wrapper.np_points_wrppaer').find('.positive_points').val();
        var $negative   = $this.parent().parent().siblings('.fb_wrapper.np_points_wrppaer').find('.negative_points').val();
    }
    
    var $comment    = $this.parent().parent().siblings('.fb_wrapper.fcomment_box').find('.fcomment_body').val();
    
    var $suggestion      = "";
    if (survey_data.disablesuggestion == 'no') {
        if ($this.parent().parent().siblings('.fb_wrapper.fsuggestion').find('.suggestion_wrapper .suggestion_yes').hasClass('sugg_active')) {
            $suggestion = 'yes';
        } else {
            $suggestion = 'no';
        }    
    } else {
        $suggestion = 'none';
    }
    

    if( survey_data.opticomment == 'no' && survey_is_empty( $comment )) {
        survey_notification('لطفاً متن نظر / دیدگاه را وارد کنید');
        return;
    }

    if( survey_data.optistarrating == 'no' && survey_is_empty( $rating )) {
        survey_notification('لطفاً یک امتیاز برای محصول ثبت کنید');
        return;
    }

    jQuery.ajax({
        url: survey_data.ajax_url,
        type: 'POST',
        data: {
            action: 'survey_register_comment',
            userid: $user_id,
            productid: $product_id,
            orderid: $order_id,
            positive: $positive,
            negative: $negative,
            comment: $comment,
            rating: $rating,
            suggestion: $suggestion,
            security: survey_data.registercomment,
        },
        beforeSend: function() {
            $this.closest('.survey_master_wrapper').find('.survey-element-wrapper.survey-loading').removeClass('survey-hide');
        },
        success: function(response) {

            if ( response == 'success' ) {
                if (survey_data.redirectaftersubmit == 'yes') {
                    if ($('.survey_master_wrapper').length > 1) {
                        $this.closest('.survey_master_wrapper').remove();
                        survey_notification(survey_data.thankyou_message, 'success');
                    } else {
                        window.location = survey_data.redirecturl;   
                    }
                    
                } else {
                    if ($('.survey_master_wrapper').length > 1) {
                        $this.closest('.survey_master_wrapper').remove();
                        survey_notification(survey_data.thankyou_message, 'success');
                    } else {
                        location.reload();
                    }
                }
            }
            
            if ( response == 'wrong-userid' ) {
                survey_notification('');
            }
            if ( response == 'wrong-orderid' ) {
                survey_notification('اطلاعات سفارش اشتباه است');
            }
            if ( response == 'wrong-productid' ) {
                survey_notification('اطلاعات محصول اشتباه است');
            }
            if ( response == 'wrong-positive' ) {
                survey_notification('لطفاً نقاط مثبت را وارد کنید');
            }
            if ( response == 'wrong-negative' ) {
                survey_notification('لطفاً نقاط منفی را وارد کنید');
            }
            if ( response == 'wrong-comment' ) {
                survey_notification('لطفاً متن نظر را وارد کنید');
            }
            if ( response == 'wrong-rating' ) {
                survey_notification('لطفاً یک امتیاز برای محصول ثبت کنید');
            }
            if ( response == 'wrong-suggestion' ) {
                survey_notification('لطفاً پیشنهاد خرید خود را مشخص کنید');
            }
        },
        complete: function() {
            $this.closest('.survey_master_wrapper').find('.survey-element-wrapper.survey-loading').addClass('survey-hide');
        }
    });
    

});

var survey_notification = function (message, success="", time=8000) {
    var $_bg_color = 'red';
    if( success == 'success' ) {
        var $_bg_color = 'green';
    }
    $.toast({
        text: message,
        showHideTransition: 'slide',
        textAlign: 'center',
        stack: false,
        position: 'bottom-center',
        bgColor: $_bg_color,
        textColor: '#fff', //'#721c24',
        loaderBg: '#333',
        class: 'survey_toast',
        hideAfter: time,
        allowToastClose: true,
    });
    $('.survey-element-wrapper.survey-loading').addClass('survey-hide');
}


    // check empty function
    var survey_is_empty = function (data) {
        if(typeof(data) === 'object'){
            if(JSON.stringify(data) === '{}' || JSON.stringify(data) === '[]'){
                return true;
            }else if(!data){
                return true;
            }
            return false;
        }else if(typeof(data) === 'string'){
            if(!data.trim()){
                return true;
            }
            return false;
        }else if(typeof(data) === 'undefined'){
            return true;
        }else{
            return false;
        }
    }

});
