jQuery(document).ready(function ($) {

    $('.toplevel_page_survey-master #doaction').click( function( event ) {
        if ($(this).siblings('select').find(":selected").val() == 'delete') {
            if( ! confirm( 'آیا از عمل حذف مطمئن هستید؟ رکوردهای حذف شده قابل بازیابی نیستند!' ) ) {
                event.preventDefault();
            }          
        } 
    });


    $('#survey_bulk_review').on('click',function(e) {
        e.preventDefault();
        var createReviewsBTN = $(this);

        if( confirm( 'آیا از ایجاد نظرسنجی برای همه سفارش ها مطمئن هستید؟!' ) ) {
            jQuery.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'survey_create_reviews_for_all_orders',
                },
                beforeSend: function() {
                    createReviewsBTN.text('در حال انجام ...');
                },
                success: function(response) {
                    if (response.success) {
                        $('#survey_create_review_result').addClass('survey_green').text(response.data.message).css('color','green').show().delay(4000).fadeOut('slow');
                    } else {
                        $('#survey_create_review_result').addClass('survey_red').text(response.data.message).css('color','red').show().delay(4000).fadeOut('slow');
                    }
                },
                complete: function() {
                    createReviewsBTN.text('ایجاد نظرسنجی ها');
                }
            });
        }
    });



    $('#send_test_sms').on('click',function(e) {
        e.preventDefault();
        var testBTN = $(this);
        var panel_val = $('#acf-field_64552933d76e5fb-field_6455295fd76e6fb').find(":selected").val();
        var username_val = $('#acf-field_64552933d76e5fb-field_645529c0d76e8fb').val();
        var password_val = $('#acf-field_64552933d76e5fb-field_645529ded76e9fb').val();
        var sender_val = $('#acf-field_64552933d76e5fb-field_645529ffd76eafb').val();
        var pattern_val = $('#acf-field_64552933d76e5fb-field_64552a16d76ebfb').val();
        var mobile_val = $('#acf-field_64552933d76e5fb-field_64f43534e7eedfb').val();
        
        var sms_text_val = '';
        if ( $('#acf-field_64f43edc12b45fb').length > 0 ) {
            sms_text_val = $('#acf-field_64f43edc12b45fb').val();
        }

        var is_simple_val = 'no';
        if ( ! $('.acf-field-64f43edc12b45fb').hasClass('acf-hidden')) {
            is_simple_val = 'yes';
        }

        if ( ! survey_is_mobile(mobile_val) ) {
            $('#survey_test_message').addClass('survey_red').text('شماره موبایل باید 11 رقمی بوده و با 09 شروع شود').show().delay(4000).fadeOut('slow');
            return;
        }

        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'survey_check_gateway',
                panel : panel_val,
                username : username_val,
                password : password_val,
                sender : sender_val,
                pattern : pattern_val,
                mobile : mobile_val,
                sms_text: sms_text_val,
                is_simple: is_simple_val,
            },
            beforeSend: function() {
                testBTN.text('در حال ارسال ...');
            },
            success: function(response) {
                if (response.success) {
                    $('#survey_test_message').addClass('survey_green').text(response.data.message).css('color','green').show().delay(4000).fadeOut('slow');
                } else {
                    $('#survey_test_message').addClass('survey_red').text(response.data.message).css('color','red').show().delay(4000).fadeOut('slow');
                }
            },
            complete: function() {
                testBTN.text('ارسال پیامک');
            }
        });
    });

        
    $('#survey_copy_url').on('click',function(e) {
        e.preventDefault();
        var copy_value = $(this).siblings('#surveyurl').val();
        var $this = $(this);
        survey_copy_to_clipboard(copy_value);
        
        $(this).text("کپی شد");
        setTimeout(function () {
            $("#survey_copy_url").text("کپی کردن لینک");
        }, 3000);

    });
    function survey_copy_to_clipboard(element) {
        var $temp = $("<input>");
        $("body").append($temp);
        $temp.val(element).select();
        document.execCommand("copy");
        $temp.remove();
    }








 
    $('.survey_send_sms').on('click', function(e){
        e.preventDefault();
        
        var sendsmsBTN =  $(this);
        var mobile_number = sendsmsBTN.siblings('.mobile_number').val();
        var order_number  = sendsmsBTN.siblings('.order_number').val();
        
        if( ! survey_is_mobile(mobile_number) ) {
            survey_notification('شماره موبایل معتبر نیست');
            return;
        } 
        
        // orderpage_sendsms
        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'orderpage_sendsms',
                mobile : mobile_number,
                ordernumber : order_number,
            },
            beforeSend: function() {
                $('.survey-element-wrapper.survey-loading').removeClass('survey-hide');
            },
            success: function(response) {
                
                if (response.success) {
                    survey_notification(response.data.message, 'success');
                    sendsmsBTN.hide();
                    sendsmsBTN.parent('td').siblings('td.sms_status').find('.sms_status_title').text('ارسال شده').css('color', 'green');
                } else {
                    survey_notification(response.data.message);
                    sendsmsBTN.parent('td').siblings('td.sms_status').find('.sms_status_title').text('ارسال ناموفق').css('color', 'red');
                }
            },
            complete: function() {
                $('.survey-element-wrapper.survey-loading').addClass('survey-hide');
            }
        });

    });


    $('.survey_send_email').on('click', function(e){
        e.preventDefault();
        var sendEmailBTN =  $(this);
        var email_address = sendEmailBTN.siblings('.email_address').val();        
        var order_number  = sendEmailBTN.siblings('.order_number').val();
        
        if( ! feeedback_is_email(email_address) ) {
            survey_notification('ایمیل معتبر نیست');
            return;
        };

        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'orderpage_sendemail',
                email : email_address,
                ordernumber : order_number,
            },
            beforeSend: function() {
                $('.survey-element-wrapper.survey-loading').removeClass('survey-hide');
            },
            success: function(response) {
                if (response.success) {
                    survey_notification(response.data.message, 'success');
                    sendEmailBTN.hide();
                    sendEmailBTN.parent('td').siblings('td.email_status').find('.email_status_title').text('ارسال شده').css('color', 'green');
                } else {
                    survey_notification(response.data.message);
                    sendEmailBTN.parent('td').siblings('td.email_status').find('.email_status_title').text('ارسال ناموفق').css('color', 'red');
                }
            },
            complete: function() {
                $('.survey-element-wrapper.survey-loading').addClass('survey-hide');
            }
        });
    });
    

    function survey_notification(message, success="") {
        
        var $_bg_color = 'red';
        if( success == 'success' ) {
            var $_bg_color = 'green';
        }

        $.toast({
            text: message,
            showHideTransition: 'slide',
            textAlign: 'center',
            stack: false,
            position: 'bottom-center',
            bgColor: $_bg_color,
            textColor: '#fff', //'#721c24',
            loaderBg: '#333',
            class: 'survey-error-toast',
            hideAfter: 8000,
            allowToastClose: true,
        });
        
        $('.survey-element-wrapper.survey-loading').addClass('survey-hide');
    }
















    $('#survey_send_order_sms').on('click', function(e){
        e.preventDefault();
        var sendsmsBTN =  $(this);
        var mobile_number = sendsmsBTN.siblings('#mobilenumber').val();
        var order_number  = sendsmsBTN.siblings('.ordernumber').val();
        
        if( ! survey_is_mobile(mobile_number) ) {
            survey_notification('شماره موبایل معتبر نیست');
            return;
        } 

        // orderpage_sendsms
        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'orderpage_sendsms',
                mobile : mobile_number,
                ordernumber : order_number,
            },
            beforeSend: function() {
                sendsmsBTN.parent('#fbop_sms_sendresend').siblings('.survey-element-wrapper.survey-loading').removeClass('survey-hide');
            },
            success: function(response) {
                
                if (response.success) {
                    sendsmsBTN.parent('#fbop_sms_sendresend').siblings('.fbop_ajax_response').addClass('survey_green').text(response.data.message).show().delay(4000).fadeOut('slow');
                    $('#fbopsms_status_body').addClass('survey_green').text('ارسال شده').css('color', 'green');
                    sendsmsBTN.hide();
                } else {
                    sendsmsBTN.parent('#fbop_sms_sendresend').siblings('.fbop_ajax_response').addClass('survey_red').text(response.data.message).show().delay(4000).fadeOut('slow');
                }
              
    
            },
            complete: function() {
                sendsmsBTN.parent('#fbop_sms_sendresend').siblings('.survey-element-wrapper.survey-loading').addClass('survey-hide');
            }
        });

    });
    
    $('#survey_send_order_email').on('click', function(e){
        e.preventDefault();
        var sendEmailBTN =  $(this);
        var email_address = sendEmailBTN.siblings('#emailaddress').val();        
        var order_number  = sendEmailBTN.siblings('.ordernumber').val();
        
        if( ! feeedback_is_email(email_address) ) {
            sendEmailBTN.parent('#fbop_email_sendresend').siblings('.fbop_ajax_response').addClass('survey_red').text('آدرس ایمیل گیرنده معتبر نیست').show().delay(4000).fadeOut('slow');    
            return
        };

        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'orderpage_sendemail',
                email : email_address,
                ordernumber : order_number,
            },
            beforeSend: function() {
                sendEmailBTN.parent('#fbop_email_sendresend').siblings('.survey-element-wrapper.survey-loading').removeClass('survey-hide');
            },
            success: function(response) {
                if (response.success) {
                    sendEmailBTN.parent('#fbop_email_sendresend').siblings('.fbop_ajax_response').addClass('survey_green').text(response.data.message).show().delay(4000).fadeOut('slow');
                    $('#fbopemail_status_body').addClass('survey_green').text('ارسال شده').css('color', 'green');
                    sendEmailBTN.hide();
                } else {
                    sendEmailBTN.parent('#fbop_email_sendresend').siblings('.fbop_ajax_response').addClass('survey_red').text(response.data.message).show().delay(4000).fadeOut('slow');
                }
            },
            complete: function() {
                sendEmailBTN.parent('#fbop_email_sendresend').siblings('.survey-element-wrapper.survey-loading').addClass('survey-hide');
            }
        });
    });
    
    function survey_is_mobile (mobileNumber) {
        if (typeof mobileNumber !== "string" || mobileNumber.length !== 11)
            return false;
    
        if (mobileNumber.slice(0, 2) !== "09")
            return false;
    
        for (var i = 1; i < 11; i++) {
            if (isNaN(parseInt(mobileNumber[i])))
                return false;
        }
    
        return true;
    }


    function feeedback_is_email (email) {
        var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
        return regex.test(email);
    }


});